/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class AppendableByteChannel
implements Appendable {
    private final WritableByteChannel channel;
    private final ByteBuffer bb;

    public AppendableByteChannel(WritableByteChannel channel, int size, boolean direct) {
        this.channel = channel;
        this.bb = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        if (csq != null) {
            this.append(csq, 0, csq.length());
        } else {
            this.append("null", 0, 4);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (csq != null) {
            for (int ii = start; ii < end; ++ii) {
                this.append(csq.charAt(ii));
            }
        } else {
            this.append('n').append('u').append('l').append('l');
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (!this.bb.hasRemaining()) {
            this.flush();
        }
        this.bb.put((byte)c);
        return this;
    }

    public Appendable flush() throws IOException {
        this.bb.flip();
        this.channel.write(this.bb);
        this.bb.clear();
        return this;
    }
}

