/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.vesalainen.nio.RingBuffer;

public class RingByteBuffer
extends RingBuffer<ByteBuffer, ScatteringByteChannel, GatheringByteChannel> {
    private final ByteBuffer bb1;
    private final ByteBuffer bb2;
    private final ByteBuffer[] ar2;

    public RingByteBuffer(int size) {
        this(size, false);
    }

    public RingByteBuffer(int size, boolean direct) {
        super(size, direct);
        this.bb1 = ((ByteBuffer)this.buffer).duplicate();
        this.bb2 = ((ByteBuffer)this.buffer).duplicate();
        this.ar2 = new ByteBuffer[]{this.bb1, this.bb2};
    }

    public byte get() {
        return this.get(false);
    }

    public byte get(boolean mark) {
        return (byte)(((ByteBuffer)this.buffer).get(this.rawGet(mark)) & 0xFF);
    }

    @Override
    public int implGetAt(int index) {
        return ((ByteBuffer)this.buffer).get((this.mark + index) % this.capacity) & 0xFF;
    }

    @Override
    protected ByteBuffer allocate(int size, boolean direct) {
        if (direct) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    @Override
    protected int read(ScatteringByteChannel reader, int position, int limit) throws IOException {
        this.bb1.limit(limit);
        this.bb1.position(position);
        return (int)reader.read(this.ar2, 0, 1);
    }

    @Override
    protected int read(ScatteringByteChannel reader, int position1, int limit1, int position2, int limit2) throws IOException {
        this.bb1.limit(limit1);
        this.bb1.position(position1);
        this.bb2.limit(limit2);
        this.bb2.position(position2);
        return (int)reader.read(this.ar2);
    }

    @Override
    protected int write(GatheringByteChannel writer, int position, int limit) throws IOException {
        this.bb1.limit(limit);
        this.bb1.position(position);
        return (int)writer.write(this.ar2, 0, 1);
    }

    @Override
    protected int write(GatheringByteChannel writer, int position1, int limit1, int position2, int limit2) throws IOException {
        this.bb1.limit(limit1);
        this.bb1.position(position1);
        this.bb2.limit(limit2);
        this.bb2.position(position2);
        return (int)writer.write(this.ar2);
    }

    @Override
    public String toString() {
        return super.toString() + "->'" + this.getString() + "'";
    }
}

