/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;

public abstract class RingBuffer<B extends Buffer, R, W>
implements CharSequence {
    protected final B buffer;
    protected int position;
    protected int mark = -1;
    protected int limit;
    protected final int capacity;
    protected int remaining;
    protected int marked;
    private final Splitter<R> readSplitter;
    private final Splitter<W> writeSplitter;

    public RingBuffer(int size, boolean direct) {
        this.buffer = this.allocate(size, direct);
        this.position = 0;
        this.mark = -1;
        this.limit = 0;
        this.capacity = ((Buffer)this.buffer).capacity();
        this.readSplitter = new Splitter<R>(){

            @Override
            protected int op(R reader, int position, int limit) throws IOException {
                return RingBuffer.this.read(reader, position, limit);
            }

            @Override
            protected int op(R reader, int position1, int limit1, int position2, int limit2) throws IOException {
                return RingBuffer.this.read(reader, position1, limit1, position2, limit2);
            }
        };
        this.writeSplitter = new Splitter<W>(){

            @Override
            protected int op(W writer, int position, int limit) throws IOException {
                return RingBuffer.this.write(writer, position, limit);
            }

            @Override
            protected int op(W writer, int position1, int limit1, int position2, int limit2) throws IOException {
                return RingBuffer.this.write(writer, position1, limit1, position2, limit2);
            }
        };
    }

    protected abstract B allocate(int var1, boolean var2);

    public final boolean hasRemaining() {
        return this.remaining > 0;
    }

    public boolean isFull() {
        return this.marked + this.remaining == this.capacity;
    }

    public final int remaining() {
        return this.remaining;
    }

    public final void mark() {
        this.mark = this.position;
        this.marked = 0;
    }

    public int getAt(int index) {
        if (index > this.marked) {
            throw new IndexOutOfBoundsException();
        }
        return this.implGetAt(index);
    }

    public abstract int implGetAt(int var1);

    protected final int rawGet(boolean markIt) {
        if (this.hasRemaining()) {
            if (markIt) {
                this.mark = this.position;
                this.marked = 1;
            } else {
                ++this.marked;
            }
            int pos = this.position;
            this.position = (this.position + 1) % this.capacity;
            --this.remaining;
            return pos;
        }
        throw new BufferUnderflowException();
    }

    public void getAll(boolean markIt) {
        if (markIt) {
            this.mark = this.position;
            this.marked = this.remaining;
        } else {
            this.marked += this.remaining;
        }
        this.position = (this.position + this.remaining) % this.capacity;
        this.remaining = 0;
    }

    public int read(R reader) throws IOException {
        int lim = this.mark == -1 ? this.position : this.mark;
        int count = this.readSplitter.doIt(reader, this.limit, lim);
        if (count != -1) {
            this.limit = (this.limit + count) % this.capacity;
            this.remaining += count;
        }
        return count;
    }

    protected abstract int read(R var1, int var2, int var3) throws IOException;

    protected abstract int read(R var1, int var2, int var3, int var4, int var5) throws IOException;

    public int write(W writer) throws IOException {
        return this.write(writer, this.mark);
    }

    public int write(W writer, int mrk) throws IOException {
        if (mrk == -1) {
            return 0;
        }
        int count = this.writeSplitter.doIt(writer, mrk, this.position);
        return count;
    }

    public int getPosition() {
        return this.position;
    }

    protected abstract int write(W var1, int var2, int var3) throws IOException;

    protected abstract int write(W var1, int var2, int var3, int var4, int var5) throws IOException;

    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.marked; ++ii) {
            sb.append(this.charAt(ii));
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "RingBuffer{m=" + this.mark + ", p=" + this.position + ", l=" + this.limit + ", c=" + this.capacity + ", r=" + this.remaining + '}';
    }

    @Override
    public int length() {
        return this.marked;
    }

    @Override
    public char charAt(int index) {
        return (char)this.getAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int ii = start; ii < end; ++ii) {
            sb.append((char)this.getAt(ii));
        }
        return sb.toString();
    }

    private abstract class Splitter<T> {
        private Splitter() {
        }

        public int doIt(T obj, int start, int end) throws IOException {
            int c = ((Buffer)RingBuffer.this.buffer).capacity();
            int count = start < end ? this.op(obj, start, end) : (end > 0 ? this.op(obj, start, c, 0, end) : this.op(obj, start, c));
            return count;
        }

        protected abstract int op(T var1, int var2, int var3) throws IOException;

        protected abstract int op(T var1, int var2, int var3, int var4, int var5) throws IOException;
    }
}

