/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.net.sntp;

import java.net.DatagramPacket;
import org.apache.commons.net.ntp.NtpV3Impl;
import org.vesalainen.net.sntp.ReferenceIdentifier;

public class NtpV4Impl
extends NtpV3Impl {
    protected byte[] buf;

    public NtpV4Impl() {
        DatagramPacket datagramPacket = this.getDatagramPacket();
        this.buf = datagramPacket.getData();
        this.setVersion(4);
    }

    public void setReferenceId(ReferenceIdentifier referenceIdentifier) {
        int id = 0;
        String name = referenceIdentifier.name();
        for (int ii = 0; ii < 4; ++ii) {
            id <<= 8;
            if (name.length() <= ii) continue;
            id += name.charAt(ii);
        }
        this.setReferenceId(id);
    }

    public void setRootDelay(int value) {
        this.setInt(4, value);
    }

    public void setRootDispersion(int value) {
        this.setInt(8, value);
    }

    protected void setInt(int index, int value) {
        this.buf[index + 3] = (byte)(value & 0xFF);
        this.buf[index + 2] = (byte)((value >>= 8) & 0xFF);
        this.buf[index + 1] = (byte)((value >>= 8) & 0xFF);
        this.buf[index] = (byte)((value >>= 8) & 0xFF);
    }
}

