/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vesalainen.navi.LocationObserver;

public abstract class LocationSource
implements LocationObserver {
    private static final Map<Object, LocationSource> sources = new HashMap<Object, LocationSource>();
    private static LocationSource current;
    private static final List<LocationObserver> observers;

    public static void register(Object key, LocationSource source) {
        sources.put(key, source);
    }

    public static void unregister(Object key) {
        sources.remove(key);
    }

    public static void addObserver(LocationObserver observer) {
        observers.add(observer);
    }

    public static void removeObserver(LocationObserver observer) {
        observers.remove(observer);
    }

    public static void activate(Object key) throws Exception {
        LocationSource source = sources.get(key);
        if (source == null) {
            throw new IllegalArgumentException("source for key " + key + " not found");
        }
        if (current != null) {
            current.stop();
        }
        current = source;
        current.start();
    }

    public static void deactivate() throws Exception {
        if (current != null) {
            current.stop();
            current = null;
        }
    }

    protected abstract void start() throws Exception;

    protected abstract void stop() throws Exception;

    @Override
    public void update(double longitude, double latitude, long time) {
        for (LocationObserver observer : observers) {
            observer.update(longitude, latitude, time);
        }
    }

    @Override
    public void update(double longitude, double latitude, long time, double accuracy) {
        for (LocationObserver observer : observers) {
            observer.update(longitude, latitude, time, accuracy);
        }
    }

    @Override
    public void update(double longitude, double latitude, long time, double accuracy, double speed) {
        for (LocationObserver observer : observers) {
            observer.update(longitude, latitude, time, accuracy, speed);
        }
    }

    @Override
    public void reset() {
        for (LocationObserver observer : observers) {
            observer.reset();
        }
    }

    static {
        observers = new ArrayList<LocationObserver>();
    }
}

