/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.io.Serializable;

public class LocalLongitude
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double departure;

    private LocalLongitude(double latitude) {
        this.departure = Math.cos(Math.toRadians(latitude));
    }

    public static LocalLongitude getInstance(double longitude, double latitude) {
        if (Math.abs(longitude) < 179.0) {
            return new LocalLongitude(latitude);
        }
        return new PacificLongitude(latitude);
    }

    public double getInternal(double longitude) {
        return longitude * this.departure;
    }

    public double getExternal(double longitude) {
        return longitude / this.departure;
    }

    private static class PacificLongitude
    extends LocalLongitude {
        private PacificLongitude(double latitude) {
            super(latitude);
        }

        @Override
        public double getExternal(double longitude) {
            if ((longitude = super.getExternal(longitude)) < -180.0) {
                longitude = 360.0 + longitude;
            }
            return longitude;
        }

        @Override
        public double getInternal(double longitude) {
            if (longitude > 0.0) {
                longitude = -360.0 + longitude;
            }
            return super.getInternal(longitude);
        }
    }
}

