/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.navi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.vesalainen.math.AbstractCircle;
import org.vesalainen.math.AbstractPoint;
import org.vesalainen.math.Circle;
import org.vesalainen.math.CircleFitter;
import org.vesalainen.math.Circles;
import org.vesalainen.math.ConvexPolygon;
import org.vesalainen.math.Point;
import org.vesalainen.navi.LocalLongitude;
import org.vesalainen.navi.LocationObserver;
import org.vesalainen.navi.SafeSector;

public class AnchorWatch
implements Serializable,
LocationObserver {
    private static final long serialVersionUID = 1L;
    private static final double DegreeToMeters = 9.0E-6;
    private ConvexPolygon area;
    private DenseMatrix64F points;
    private DenseMatrix64F tempCenter;
    private Point center;
    private AbstractCircle estimated;
    private ConvexPolygon outer;
    private CircleFitter fitter;
    private final List<Watcher> watchers = new ArrayList<Watcher>();
    private double chainLength = 5.4E-4;
    private SafeSector safeSector;
    private LocalLongitude localLongitude;
    private double lastLongitude = Double.NaN;
    private double lastLatitude = Double.NaN;
    private long lastTime = -1L;

    public AnchorWatch() {
        this.reset();
    }

    @Override
    public final void reset() {
        this.tempCenter = new DenseMatrix64F(2, 1);
        this.points = new DenseMatrix64F(0, 2);
        this.area = new ConvexPolygon();
        this.outer = new ConvexPolygon();
        this.center = null;
        this.estimated = null;
        this.fitter = null;
        this.safeSector = null;
        this.localLongitude = null;
        this.lastLongitude = Double.NaN;
        this.lastLatitude = Double.NaN;
        this.lastTime = -1L;
    }

    @Override
    public void update(double longitude, double latitude, long time) {
        this.update(longitude, latitude, time, Double.NaN);
    }

    @Override
    public void update(double longitude, double latitude, long time, double accuracy) {
        if (this.localLongitude == null) {
            this.localLongitude = LocalLongitude.getInstance(longitude, latitude);
        }
        double internal = this.localLongitude.getInternal(longitude);
        if (Double.isNaN(this.lastLongitude)) {
            this.doUpdate(internal, latitude, time, accuracy, 0.0);
        } else {
            double distance = Math.hypot(internal - this.lastLongitude, latitude - this.lastLatitude);
            double dTime = (double)(time - this.lastTime) / 1000.0;
            double speed = AnchorWatch.toMeters(distance / dTime);
            this.doUpdate(internal, latitude, time, accuracy, speed);
        }
        this.lastLongitude = internal;
        this.lastLatitude = latitude;
        this.lastTime = time;
    }

    @Override
    public void update(double longitude, double latitude, long time, double accuracy, double speed) {
        if (this.localLongitude == null) {
            this.localLongitude = LocalLongitude.getInstance(longitude, latitude);
        }
        double internal = this.localLongitude.getInternal(longitude);
        this.doUpdate(internal, latitude, time, accuracy, speed);
        this.lastLongitude = internal;
        this.lastLatitude = latitude;
        this.lastTime = time;
    }

    private void doUpdate(double internal, double latitude, long time, double accuracy, double speed) {
        if (this.fitter != null && !this.safeSector.isInside(internal, latitude)) {
            double distance = Circles.distanceFromCenter(this.safeSector, internal, latitude);
            this.fireAlarm(AnchorWatch.toMeters(distance));
        }
        this.fireLocation(internal, latitude, time, accuracy, speed);
        if (this.area.addPoint(internal, latitude)) {
            double radius;
            this.fireArea(this.area);
            this.points.setReshape(this.area.points);
            if (this.fitter == null && !Double.isNaN(radius = CircleFitter.initialCenter(this.points, this.tempCenter))) {
                this.fitter = new CircleFitter();
                this.center = new AbstractPoint(this.tempCenter.data[0], this.tempCenter.data[1]);
                this.estimated = new AbstractCircle(this.center, this.chainLength);
                this.safeSector = new SafeSector(this.estimated);
            }
            if (this.fitter != null) {
                if (!this.area.isInside(this.center)) {
                    this.area.getOuterBoundary(this.safeSector, this.outer);
                    this.fireOuter(this.outer.points);
                    this.fitter.fit(this.safeSector, this.outer.points);
                } else {
                    this.fitter.fit(this.safeSector, this.area.points);
                }
                this.estimated.set(this.fitter);
                this.fireEstimated(this.estimated);
                this.fireSafeSector(this.safeSector);
            }
        } else {
            double minimumDistance = this.area.getMinimumDistance(internal, latitude);
            if (!Double.isNaN(accuracy) && !Double.isInfinite(accuracy)) {
                minimumDistance = Math.max(0.0, minimumDistance - accuracy);
            }
            this.fireSuggestNextUpdateIn(minimumDistance / speed, minimumDistance);
        }
    }

    public boolean setAnchorLocation() {
        if (this.safeSector != null && !Double.isNaN(this.lastLongitude)) {
            this.safeSector.set(this.lastLongitude, this.lastLatitude);
            return true;
        }
        return false;
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.fitter.getRadius();
    }

    public ConvexPolygon getArea() {
        return this.area;
    }

    public void setChainLength(int meters) {
        this.chainLength = (double)meters * 9.0E-6;
    }

    public static double toMeters(double degrees) {
        return degrees / 9.0E-6;
    }

    public void addWatcher(Watcher watcher) {
        if (watcher == null) {
            throw new NullPointerException();
        }
        this.watchers.add(watcher);
    }

    public void removeWatcher(Watcher watcher) {
        this.watchers.remove(watcher);
    }

    private void fireLocation(double x, double y, long time, double accuracy, double speed) {
        for (Watcher watcher : this.watchers) {
            watcher.location(x, y, time, accuracy, speed);
        }
    }

    private void fireAlarm(double distance) {
        for (Watcher watcher : this.watchers) {
            watcher.alarm(distance);
        }
    }

    private void fireArea(ConvexPolygon area) {
        for (Watcher watcher : this.watchers) {
            watcher.area(area);
        }
    }

    private void fireOuter(DenseMatrix64F path) {
        for (Watcher watcher : this.watchers) {
            watcher.outer(path);
        }
    }

    private void fireEstimated(Circle estimated) {
        for (Watcher watcher : this.watchers) {
            watcher.estimated(estimated);
        }
    }

    private void fireSafeSector(SafeSector safe) {
        for (Watcher watcher : this.watchers) {
            watcher.safeSector(safe);
        }
    }

    private void fireSuggestNextUpdateIn(double seconds, double meters) {
        for (Watcher watcher : this.watchers) {
            watcher.suggestNextUpdateIn(seconds, meters);
        }
    }

    public class Center
    implements Point {
        private double[] data;

        public Center(DenseMatrix64F m) {
            this.data = m.data;
        }

        @Override
        public double getX() {
            return this.data[0];
        }

        @Override
        public double getY() {
            return this.data[1];
        }
    }

    public static interface Watcher {
        public void alarm(double var1);

        public void location(double var1, double var3, long var5, double var7, double var9);

        public void area(ConvexPolygon var1);

        public void outer(DenseMatrix64F var1);

        public void estimated(Circle var1);

        public void safeSector(SafeSector var1);

        public void suggestNextUpdateIn(double var1, double var3);
    }
}

