/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import org.vesalainen.math.UnitCategory;

public enum UnitType {
    MSS(UnitCategory.Acceleration, 1.0, "g"),
    GFORCEEARTH(UnitCategory.Acceleration, 9.80665, "g"),
    PASCAL(UnitCategory.Pressure, 1.0, "Pa"),
    HPA(UnitCategory.Pressure, 100.0, "hPa"),
    BAR(UnitCategory.Pressure, 100000.0, "bar"),
    ATM(UnitCategory.Pressure, 101325.0, "atm"),
    DEGREE(UnitCategory.PlaneAngle, 1.0, "\u00b0"),
    RADIAN(UnitCategory.PlaneAngle, Math.toDegrees(1.0), "Rad"),
    CELSIUS(UnitCategory.Temperature, 1.0, "\u00b0C"),
    FAHRENHEIT(UnitCategory.Temperature, 0.5555555555555556, -32.0, "Fahrenheit"),
    KELVIN(UnitCategory.Temperature, 1.0, -273.15, "Kelvin"),
    FATHOM(UnitCategory.Length, 1.8288, "Fathom"),
    METER(UnitCategory.Length, 1.0, "m"),
    MILE(UnitCategory.Length, 1609.34, "Mile"),
    FOOT(UnitCategory.Length, 0.3048, "Foot"),
    YARD(UnitCategory.Length, 0.9144, "Yard"),
    INCH(UnitCategory.Length, 0.0254, "Inch"),
    KILOMETER(UnitCategory.Length, 1000.0, "Km"),
    NM(UnitCategory.Length, 1852.0, "NM"),
    MH(UnitCategory.Speed, 0.44704, "Miles/h"),
    KNOT(UnitCategory.Speed, 0.514444, "Knots"),
    MS(UnitCategory.Speed, 1.0, "m/s"),
    KMH(UnitCategory.Speed, 0.277778, "Km/h"),
    BEAUFORT(UnitCategory.Speed, 0.837, "B"),
    DEG(UnitCategory.Coordinate, Double.NaN, "\u02da"),
    DEGMIN(UnitCategory.Coordinate, Double.NaN, ""),
    DEGMINSEC(UnitCategory.Coordinate, Double.NaN, "");

    private final UnitCategory category;
    private final double multiplier;
    private final double offset;
    private final String unit;

    private UnitType(UnitCategory category, double multiplier, double offset, String unit) {
        this.category = category;
        this.multiplier = multiplier;
        this.offset = offset;
        this.unit = unit;
    }

    private UnitType(UnitCategory category, double multiplier, String unit) {
        this.category = category;
        this.multiplier = multiplier;
        this.offset = 0.0;
        this.unit = unit;
    }

    public double convertTo(double value, UnitType to) {
        if (this.equals((Object)to)) {
            return value;
        }
        if (!this.category.equals((Object)to.getCategory())) {
            throw new IllegalArgumentException((Object)((Object)this) + " cannot be converted to " + (Object)((Object)to));
        }
        if (Double.isNaN(this.multiplier) || Double.isNaN(to.multiplier)) {
            throw new UnsupportedOperationException("conversion from " + (Object)((Object)this) + " to " + (Object)((Object)to) + " not supported");
        }
        if (this.equals((Object)BEAUFORT)) {
            double ms = to.convertTo(value, MS);
            return this.multiplier * Math.pow(ms, 1.5);
        }
        if (to.equals((Object)BEAUFORT)) {
            double ms = this.convertTo(value, MS);
            double d = ms / this.multiplier;
            double pow = Math.pow(d, 0.6666666666666666);
            return Math.round(Math.pow(ms / to.multiplier, 0.6666666666666666));
        }
        return (value + this.offset) * this.multiplier / to.multiplier - to.offset;
    }

    public UnitCategory getCategory() {
        return this.category;
    }

    public String getUnit() {
        return this.unit;
    }
}

