/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;

public class Rect
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double xMax = Double.NaN;
    public double yMax = Double.NaN;
    public double xMin = Double.NaN;
    public double yMin = Double.NaN;

    public boolean isInside(double x, double y) {
        return !(x > this.xMax || x < this.xMin || y > this.yMax || y < this.yMin);
    }

    public double getWidth() {
        return this.xMax - this.xMin;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }

    public void reset() {
        this.xMin = Double.NaN;
        this.xMax = Double.NaN;
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
    }

    public void update(double x, double y, double radius) {
        this.update(x, y);
        this.update(x - radius, y - radius);
        this.update(x + radius, y - radius);
        this.update(x - radius, y + radius);
        this.update(x + radius, y + radius);
    }

    public void update(double x, double y) {
        boolean changed = false;
        if (x < this.xMin || Double.isNaN(this.xMin)) {
            this.xMin = x;
            changed = true;
        }
        if (x > this.xMax || Double.isNaN(this.xMax)) {
            this.xMax = x;
            changed = true;
        }
        if (y < this.yMin || Double.isNaN(this.yMin)) {
            this.yMin = y;
            changed = true;
        }
        if (y > this.yMax || Double.isNaN(this.yMax)) {
            this.yMax = y;
            changed = true;
        }
    }

    public final void setRect(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    public void set(Rect oth) {
        this.xMin = oth.xMin;
        this.xMax = oth.xMax;
        this.yMin = oth.yMin;
        this.yMax = oth.yMax;
    }
}

