/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import org.ejml.data.DenseMatrix64F;

public final class Matrices {
    public static boolean removeRow(DenseMatrix64F m, double ... row) {
        int idx = Matrices.findRow(m, row);
        if (idx != -1) {
            Matrices.removeRowAt(m, idx);
            return true;
        }
        return false;
    }

    public static boolean containsRow(DenseMatrix64F m, double ... row) {
        return Matrices.findRow(m, row) != -1;
    }

    public static int findRow(DenseMatrix64F m, double ... row) {
        int cols = m.numCols;
        if (row.length != cols) {
            throw new IllegalArgumentException("illegal column count");
        }
        double[] d = m.data;
        int rows = m.numRows;
        for (int r = 0; r < rows; ++r) {
            boolean eq = true;
            for (int c = 0; c < cols; ++c) {
                if (d[cols * r + c] == row[c]) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return r;
        }
        return -1;
    }

    public static void setRow(DenseMatrix64F m, int index, double ... row) {
        int cols = m.numCols;
        if (row.length != cols) {
            throw new IllegalArgumentException("illegal column count");
        }
        System.arraycopy(row, 0, m.data, cols * index, row.length);
    }

    public static void addRow(DenseMatrix64F m, double x, double y) {
        int cols = m.numCols;
        int rows = m.numRows;
        m.reshape(rows + 1, cols, true);
        m.data[cols * rows] = x;
        m.data[cols * rows + 1] = y;
    }

    public static void addRow(DenseMatrix64F m, double ... row) {
        int cols = m.numCols;
        if (row.length != cols) {
            throw new IllegalArgumentException("illegal column count");
        }
        int rows = m.numRows;
        m.reshape(rows + 1, cols, true);
        System.arraycopy(row, 0, m.data, cols * rows, row.length);
    }

    public static void insertRow(DenseMatrix64F m, int index, double ... row) {
        int cols = m.numCols;
        if (row.length != cols) {
            throw new IllegalArgumentException("illegal column count");
        }
        int rows = m.numRows;
        m.reshape(rows + 1, cols, true);
        double[] d = m.data;
        System.arraycopy(d, cols * index, d, cols * (index + 1), cols * (rows - index));
        System.arraycopy(row, 0, d, cols * index, row.length);
    }

    public static void removeRowAt(DenseMatrix64F m, int index) {
        int cols = m.numCols;
        int rows = m.numRows;
        double[] d = m.data;
        System.arraycopy(d, cols * (index + 1), d, cols * index, cols * (rows - index - 1));
        m.reshape(rows - 1, cols, true);
    }

    public static void removeEqualRows(DenseMatrix64F matrix) {
        int rows = matrix.numRows;
        if (rows < 2) {
            return;
        }
        double[] d = matrix.data;
        int cols = matrix.numCols;
        int left = rows - 1;
        int delta = 0;
        for (int i = 0; i < left; ++i) {
            int j;
            for (j = i; j < left && Matrices.eq(d, i, j + 1, cols); ++j) {
            }
            if (i == j) continue;
            int cnt = j - i;
            System.arraycopy(d, cols * j, d, cols * i, cols * (left - j + 1));
            left -= cnt;
            delta += cnt;
        }
        if (Matrices.eq(d, 0, rows - 1, cols)) {
            ++delta;
        }
        if (delta > 0) {
            matrix.reshape(rows - delta, cols, true);
        }
    }

    private static boolean eq(double[] d, int i1, int i2, int cols) {
        for (int ii = 0; ii < cols; ++ii) {
            if (d[cols * i1 + ii] == d[cols * i2 + ii]) continue;
            return false;
        }
        return true;
    }

    public static void sort(DenseMatrix64F matrix, RowComparator comparator) {
        int len = matrix.numCols;
        Matrices.quickSort(matrix.data, 0, matrix.numRows - 1, len, comparator, new double[len], new double[len]);
    }

    public static void sort(double[] data, int rowLength, RowComparator comparator) {
        Matrices.quickSort(data, 0, (data.length - 1) / rowLength, rowLength, comparator, new double[rowLength], new double[rowLength]);
    }

    private static void quickSort(double[] arr, int left, int right, int len, RowComparator c, double[] pivot, double[] tmp) {
        int i = left;
        int j = right;
        System.arraycopy(arr, (left + right) / 2 * len, pivot, 0, len);
        while (i <= j) {
            while (c.compare(arr, i, pivot, len) < 0) {
                ++i;
            }
            while (c.compare(arr, j, pivot, len) > 0) {
                --j;
            }
            if (i > j) continue;
            if (i != j) {
                System.arraycopy(arr, i * len, tmp, 0, len);
                System.arraycopy(arr, j * len, arr, i * len, len);
                System.arraycopy(tmp, 0, arr, j * len, len);
            }
            ++i;
            --j;
        }
        if (left < j) {
            Matrices.quickSort(arr, left, j, len, c, pivot, tmp);
        }
        if (i < right) {
            Matrices.quickSort(arr, i, right, len, c, pivot, tmp);
        }
    }

    public static interface RowComparator {
        public int compare(double[] var1, int var2, double[] var3, int var4);
    }
}

