/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;
import org.vesalainen.math.AbstractPoint;
import org.vesalainen.math.CubicBezierCurve;
import org.vesalainen.math.Point;

public class CubicSplineCurve
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double Epsilon = 1.0E-5;
    private double epsilon = 1.0E-5;
    private Point[] S;
    private Point[] P;
    private CubicBezierCurve[] cbc;
    private AbstractPoint tmpPoint = new AbstractPoint();
    private AbstractPoint tmpKey = new AbstractPoint();
    private CubicSplineCurveKey tmpCSCKey = new CubicSplineCurveKey();

    public CubicSplineCurve(List<Point> points) {
        this(1.0E-5, points.toArray(new Point[points.size()]));
    }

    public CubicSplineCurve(double epsilon, List<Point> points) {
        this(epsilon, points.toArray(new Point[points.size()]));
    }

    public CubicSplineCurve(Point ... points) {
        this(1.0E-5, points);
    }

    public CubicSplineCurve(double ... points) {
        this(1.0E-5, CubicSplineCurve.createPoints(points));
    }

    private static Point[] createPoints(double ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("point count must be even");
        }
        Point[] pa = new Point[points.length / 2];
        for (int ii = 0; ii < pa.length; ++ii) {
            pa[ii] = new AbstractPoint(points[2 * ii], points[2 * ii + 1]);
        }
        return pa;
    }

    public CubicSplineCurve(double epsilon, Point ... points) {
        int ii;
        DenseMatrix64F inv;
        this.epsilon = epsilon;
        this.S = points;
        Point[] B = new Point[this.S.length];
        B[0] = this.S[0];
        B[B.length - 1] = this.S[this.S.length - 1];
        Point[] C = new Point[this.S.length - 2];
        C[0] = AbstractPoint.subtract(AbstractPoint.mul(6.0, this.S[1]), this.S[0]);
        C[C.length - 1] = AbstractPoint.subtract(AbstractPoint.mul(6.0, this.S[this.S.length - 2]), this.S[this.S.length - 1]);
        for (int ii2 = 1; ii2 < this.S.length - 3; ++ii2) {
            C[ii2] = AbstractPoint.mul(6.0, this.S[ii2 + 1]);
        }
        DenseMatrix64F mC = new DenseMatrix64F(C.length, 2, true, AbstractPoint.toArray(C));
        DenseMatrix64F m141 = CubicSplineCurve.get141Matrix(C.length);
        boolean ok = CommonOps.invert((DenseMatrix64F)m141, (DenseMatrix64F)(inv = new DenseMatrix64F(m141.numRows, m141.numCols)));
        if (!ok) {
            throw new IllegalArgumentException("cound not invert");
        }
        DenseMatrix64F mB = new DenseMatrix64F(C.length, 2);
        CommonOps.mult((RowD1Matrix64F)inv, (RowD1Matrix64F)mC, (RowD1Matrix64F)mB);
        for (ii = 1; ii < B.length - 1; ++ii) {
            B[ii] = new AbstractPoint(mB.get(ii - 1, 0), mB.get(ii - 1, 1));
        }
        this.P = new Point[3 * (B.length - 1) + 1];
        this.P[0] = this.S[0];
        for (ii = 1; ii < B.length; ++ii) {
            Point[] mids = AbstractPoint.midPoints(2, B[ii - 1], B[ii]);
            this.P[(ii - 1) * 3 + 1] = mids[0];
            this.P[(ii - 1) * 3 + 2] = mids[1];
            this.P[(ii - 1) * 3 + 3] = this.S[ii];
        }
        this.cbc = new CubicBezierCurve[B.length - 1];
        for (ii = 0; ii < this.cbc.length; ++ii) {
            this.cbc[ii] = new CubicBezierCurve(3 * ii, this.P);
        }
    }

    public Point head() {
        return this.S[0];
    }

    public Point tail() {
        return this.S[this.S.length - 1];
    }

    private Point eval(CubicSplineCurveKey key) {
        if (key.t == 0.0) {
            return this.S[key.bezierIndex];
        }
        return this.eval(key.bezierIndex, key.t);
    }

    private Point eval(int piece, double t) {
        return this.cbc[piece].eval(t, this.tmpPoint);
    }

    public Point[] getPoints() {
        return this.S;
    }

    public CubicSplineCurve transpose() {
        ArrayList<Point> tr = new ArrayList<Point>();
        for (int ii = 0; ii < this.S.length; ++ii) {
            tr.add(new AbstractPoint(this.S[ii].getY(), this.S[ii].getX()));
        }
        if (((Point)tr.get(0)).getX() > ((Point)tr.get(tr.size() - 1)).getX()) {
            Collections.reverse(tr);
        }
        return new CubicSplineCurve(tr);
    }

    public static final DenseMatrix64F get141Matrix(int order) {
        if (order < 2) {
            throw new IllegalArgumentException("order has to be at least 2 for 1 4 1 matrix");
        }
        double[] data = new double[order * order];
        for (int row = 0; row < order; ++row) {
            for (int col = 0; col < order; ++col) {
                int index = row * order + col;
                data[index] = row == col ? 4.0 : (Math.abs(row - col) == 1 ? 1.0 : 0.0);
            }
        }
        return new DenseMatrix64F(order, order, true, data);
    }

    public double average(double interval) {
        double res = 0.0;
        Iterator<Point> it = this.iterator(interval);
        Point p1 = it.next();
        while (it.hasNext()) {
            Point p2 = it.next();
            res += (p2.getX() - p1.getX()) * (p1.getY() + p2.getY()) / 2.0;
            p1 = p2;
        }
        return res / (this.S[this.S.length - 1].getX() - this.S[0].getX());
    }

    public double average(double startX, double endX, double interval) {
        double res = 0.0;
        Iterator<Point> it = this.iterator(startX, endX, interval);
        Point p1 = it.next();
        while (it.hasNext()) {
            Point p2 = it.next();
            res += (p2.getX() - p1.getX()) * (p1.getY() + p2.getY()) / 2.0;
            p1 = p2;
        }
        return res / (endX - startX);
    }

    public Iterator<Point> iterator(double interval) {
        return new Iter(this, interval);
    }

    public Iterator<Point> iterator(double startX, double endX, double interval) {
        CubicSplineCurveKey start = this.getNearestKey(startX, this.epsilon, new CubicSplineCurveKey());
        CubicSplineCurveKey end = this.getNearestKey(endX, this.epsilon, new CubicSplineCurveKey());
        return new Iter(this, interval, start, end);
    }

    public double get(double x) {
        return this.get(x, this.epsilon);
    }

    public double get(double x, double epsilon) {
        Point nearest = this.getNearest(x, epsilon);
        return nearest.getY();
    }

    public Point getNearest(double x, double epsilon) {
        return this.getNearest(x, epsilon, this.tmpCSCKey);
    }

    private Point getNearest(double x, double epsilon, CubicSplineCurveKey cscKey) {
        CubicSplineCurveKey key = this.getNearestKey(x, epsilon, cscKey);
        return this.eval(key);
    }

    private CubicSplineCurveKey getNearestKey(double x, double epsilon, CubicSplineCurveKey key) {
        if (Math.abs(this.S[0].getX() - x) < epsilon) {
            x = this.S[0].getX();
        }
        if (Math.abs(this.S[this.S.length - 1].getX() - x) < epsilon) {
            x = this.S[this.S.length - 1].getX();
        }
        this.tmpKey.set(x, 0.0);
        int idx = AbstractPoint.searchX(this.S, (Point)this.tmpKey);
        if (idx >= 0 && AbstractPoint.compareX(this.S[idx], this.tmpKey) == 0) {
            key.bezierIndex = idx;
            key.t = 0.0;
            return key;
        }
        if (idx < 0) {
            idx = -idx - 1;
        }
        if (idx == 0 || idx == this.S.length) {
            throw new IllegalArgumentException("x=" + x + " outside interpolator range");
        }
        double t = 0.5;
        double change = 0.25;
        Point res = this.eval(idx - 1, t);
        while (Math.abs(res.getX() - x) > epsilon) {
            t = Double.compare(x, res.getX()) < 0 ? (t -= change) : (t += change);
            change /= 2.0;
            res = this.eval(idx - 1, t);
        }
        key.bezierIndex = idx - 1;
        key.t = t;
        return key;
    }

    public class CubicSplineCurveKey {
        protected int bezierIndex;
        protected double t;

        public CubicSplineCurveKey() {
        }

        private CubicSplineCurveKey(int bezierIndex, double t) {
            this.bezierIndex = bezierIndex;
            this.t = t;
        }
    }

    private class Iter
    implements Iterator<Point> {
        private CubicSplineCurve csc;
        private int index;
        private int end;
        private double t;
        private double tEnd;
        private double interval;

        private Iter(CubicSplineCurve csc, double interval) {
            this.csc = csc;
            this.end = csc.cbc.length;
            this.tEnd = 1.0;
            this.interval = interval;
        }

        private Iter(CubicSplineCurve csc, double interval, CubicSplineCurveKey start, CubicSplineCurveKey end) {
            this.csc = csc;
            this.interval = interval;
            this.index = start.bezierIndex;
            this.t = start.t;
            this.end = end.bezierIndex;
            this.tEnd = end.t;
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.end) {
                return true;
            }
            return this.index < this.end && this.t <= this.tEnd;
        }

        @Override
        public Point next() {
            Point res = this.csc.eval(this.index, this.t);
            this.t += this.interval;
            if (this.t > 1.0) {
                ++this.index;
                this.t = 0.0;
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

