/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.vesalainen.io.Pushbackable;

public class PushbackReadable
implements Readable,
AutoCloseable,
Pushbackable<CharBuffer> {
    protected final Readable in;
    private Deque<CharBuffer> stack;

    public PushbackReadable(Readable in) {
        this.in = in;
    }

    @Override
    public int read(CharBuffer cb) throws IOException {
        CharBuffer peek;
        if (this.stack == null || this.stack.isEmpty()) {
            return this.in.read(cb);
        }
        int count = 0;
        while (cb.hasRemaining() && (peek = this.stack.peek()) != null) {
            int rc = peek.read(cb);
            assert (rc != -1);
            count += rc;
            if (peek.hasRemaining()) continue;
            this.stack.pop();
        }
        return count;
    }

    @Override
    public void close() throws Exception {
        if (this.in instanceof Closeable) {
            Closeable c = (Closeable)((Object)this.in);
            c.close();
        }
    }

    public void pushback(CharBuffer ... buffers) throws IOException {
        if (this.stack == null) {
            this.stack = new ArrayDeque<CharBuffer>();
        }
        int size = 0;
        for (CharBuffer cb : buffers) {
            size += cb.remaining();
        }
        CharBuffer nbuf = CharBuffer.allocate(size);
        for (CharBuffer cb : buffers) {
            nbuf.put(cb);
        }
        nbuf.clear();
        this.stack.push(nbuf);
    }

    @Override
    public boolean hasPushback() {
        return this.stack != null && !this.stack.isEmpty();
    }
}

