/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import org.vesalainen.code.AbstractDispatcher;
import org.vesalainen.code.TransactionalSetterClass;

public abstract class TransactionalSetter
extends AbstractDispatcher {
    protected Object intf;

    protected TransactionalSetter(int[] sizes) {
        super(sizes);
    }

    public static <T extends TransactionalSetter> T getInstance(Class<T> cls, Object intf) {
        Class<?>[] interfaces = cls.getInterfaces();
        if (interfaces.length != 1) {
            throw new IllegalArgumentException(cls + " should implement exactly one interface");
        }
        boolean ok = false;
        if (!interfaces[0].isAssignableFrom(intf.getClass())) {
            throw new IllegalArgumentException(cls + " doesn't implement " + intf);
        }
        try {
            TransactionalSetterClass annotation = cls.getAnnotation(TransactionalSetterClass.class);
            if (annotation == null) {
                throw new IllegalArgumentException("@" + TransactionalSetterClass.class.getSimpleName() + " missing in cls");
            }
            Class<?> c = Class.forName(annotation.value());
            TransactionalSetter t = (TransactionalSetter)c.newInstance();
            t.intf = intf;
            return (T)t;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

