/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.code;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.vesalainen.code.ListPrinter;

public class CodePrinter {
    private final String Indent = "    ";
    private final CharSequence indent;
    private final Appendable appendable;
    private final CharSequence suffix;
    private boolean indented;
    private boolean flushed;
    private CodePrinter parent;
    private CodePrinter sub;

    public CodePrinter(Appendable appendable) {
        this(null, "", appendable, "");
    }

    private CodePrinter(CodePrinter parent, CharSequence indent, Appendable appendable, CharSequence suffix) {
        this.parent = parent;
        this.indent = indent;
        this.appendable = appendable;
        this.suffix = suffix;
    }

    public CodePrinter createMethod(EnumSet<Modifier> modifiers, ExecutableElement method) throws IOException {
        this.println();
        for (Modifier m : modifiers) {
            this.print(m.name().toLowerCase() + " ");
        }
        TypeMirror returnType = method.getReturnType();
        this.print(returnType + " ");
        this.print(method.getSimpleName() + "(");
        ListPrinter<VariableElement> vl = new ListPrinter<VariableElement>(this, (CharSequence)", ", method.getParameters()){

            @Override
            protected void print(int index, VariableElement item) throws IOException {
                this.print(item.asType().toString() + " ");
                this.print(item.getSimpleName());
            }
        };
        vl.print();
        this.print(")");
        List<? extends TypeMirror> thrownTypes = method.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            this.print(" throws ");
            this.print((CharSequence)", ", thrownTypes);
        }
        this.println();
        this.println("{");
        return this.createSub("}");
    }

    public CodePrinter createClass(EnumSet<Modifier> modifiers, CharSequence name, TypeElement superClass, TypeElement ... interfaces) throws IOException {
        this.println();
        for (Modifier m : modifiers) {
            this.print(m.name().toLowerCase() + " ");
        }
        this.print("class ");
        this.print(name + " ");
        if (superClass != null) {
            this.print("extends " + superClass.getQualifiedName());
        }
        if (interfaces != null && interfaces.length > 0) {
            this.print(" implements ");
            ListPrinter<TypeElement> elp = new ListPrinter<TypeElement>(this, (CharSequence)", ", interfaces){

                @Override
                protected void print(int index, TypeElement item) throws IOException {
                    this.print(item.getSimpleName());
                }
            };
            elp.print();
        }
        this.println();
        this.println("{");
        return this.createSub("}");
    }

    public CodePrinter createSub(CharSequence suffix) {
        this.sub = new CodePrinter(this, this.indent + "    ", this.appendable, suffix);
        return this.sub;
    }

    void flush() throws IOException {
        if (!this.flushed && this.parent != null) {
            this.parent.println();
            this.parent.println(this.suffix);
            this.flushed = true;
        }
    }

    public <T> void print(CharSequence separator, Collection<T> items) throws IOException {
        boolean first = true;
        for (T c : items) {
            if (!first) {
                this.print(separator);
            }
            first = false;
            this.print(c.toString());
        }
    }

    public <T> void print(CharSequence separator, T[] items) throws IOException {
        boolean first = true;
        for (T c : items) {
            if (!first) {
                this.print(separator);
            }
            first = false;
            this.print(c.toString());
        }
    }

    public void println(CharSequence str) throws IOException {
        this.print(str);
        this.appendable.append('\n');
        this.indented = false;
    }

    public void print(CharSequence str) throws IOException {
        this.indent();
        this.appendable.append(str);
    }

    private void indent() throws IOException {
        if (!this.indented) {
            this.appendable.append(this.indent);
            this.indented = true;
        }
    }

    private void println() throws IOException {
        if (this.indented) {
            this.println("");
        }
    }
}

