/*
 * Decompiled with CFR 0.152.
 */
package org.vesalainen.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vesalainen.bean.BeanHelperException;
import org.vesalainen.util.ConvertUtility;
import org.vesalainen.util.ConvertUtilityException;

public class BeanHelper {
    private static final Pattern EXPR = Pattern.compile("[$]\\{([^\\}]+)\\}");
    private static final Pattern FIELDEXPR = Pattern.compile("[$]\\{([^\\}\\(\\)]+)\\}");
    private static final Pattern METHODEXPR = Pattern.compile("[$]\\{([^\\}\\(\\)]+)\\(\\)\\}");
    private static final Pattern FIELD = Pattern.compile("([^\\(\\)\\[\\]]+)");
    private static final Pattern METHOD = Pattern.compile("([^\\(\\)]+)\\(\\)");
    private static final Pattern ARRAY = Pattern.compile("\\[L([^;]+);");

    public static final Class getArrayCellClass(Class arrayClass) throws ClassNotFoundException {
        String simpleName = arrayClass.getName();
        Matcher mm = ARRAY.matcher(simpleName);
        if (mm.matches()) {
            String className = mm.group(1);
            return Class.forName(className);
        }
        throw new IllegalArgumentException(arrayClass.getName() + " is not array class");
    }

    public static final boolean isExpression(String expression) {
        return expression.startsWith("$");
    }

    public static final boolean isMethod(String expression) {
        return expression.endsWith("()");
    }

    public static final boolean isField(String expression) {
        return !BeanHelper.isMethod(expression);
    }

    public static final Object getFieldValue(Object base, String pseudoField, int index) throws BeanHelperException {
        if (index == -1) {
            return BeanHelper.getFieldValue(base, pseudoField);
        }
        Object[] arr = (Object[])BeanHelper.getFieldValue(base, pseudoField);
        return arr[index];
    }

    public static final Object getFieldValue(Object base, String pseudoField) throws BeanHelperException {
        Class<?> type = base.getClass();
        try {
            Field field = type.getField(pseudoField);
            return field.get(base);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exx) {
            String methodName = BeanHelper.getter(pseudoField);
            try {
                Method method = type.getMethod(methodName, new Class[0]);
                return method.invoke(base, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new BeanHelperException(methodName + " not found in " + base.getClass().getName(), (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                try {
                    methodName = BeanHelper.isser(pseudoField);
                    Method method = base.getClass().getMethod(methodName, new Class[0]);
                    return method.invoke(base, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex1) {
                    throw new BeanHelperException(methodName + " not found in " + base.getClass().getName(), (Throwable)ex);
                }
            }
        }
    }

    public static final void setFieldValue(Object base, String pseudoField, Object cv, int index) throws BeanHelperException, ConvertUtilityException {
        if (index == -1) {
            BeanHelper.setFieldValue(base, pseudoField, cv);
        } else {
            Object value = BeanHelper.getFieldValue(base, pseudoField);
            if (value instanceof List) {
                List list = (List)value;
                list.set(index, cv);
            } else if (value.getClass().isArray()) {
                Object[] arr = (Object[])value;
                arr[index] = cv;
            } else {
                throw new BeanHelperException("index for non indexed type", (Throwable)new BeanHelperException(base, pseudoField));
            }
        }
    }

    public static final AnnotatedElement getElement(Object base, String pseudoField) throws BeanHelperException {
        try {
            return base.getClass().getDeclaredField(pseudoField);
        }
        catch (NoSuchFieldException ex) {
            return BeanHelper.getMethod(base, pseudoField);
        }
    }

    public static final Class getType(Object base, String pseudoField) throws BeanHelperException {
        Class<?> type = base.getClass();
        try {
            Field field = type.getField(pseudoField);
            return field.getType();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Method method = BeanHelper.getMethod(base, pseudoField);
            return method.getReturnType();
        }
    }

    public static final <T extends Annotation> T getAnnotation(Object base, String pseudoField, Class<T> annotationClass) throws BeanHelperException {
        Class<?> type = base.getClass();
        try {
            Field field = type.getField(pseudoField);
            return field.getAnnotation(annotationClass);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            Method method = BeanHelper.getMethod(base, pseudoField);
            return method.getDeclaredAnnotation(annotationClass);
        }
    }

    public static final void setFieldValue(Object base, String pseudoField, Object value) throws BeanHelperException, ConvertUtilityException {
        try {
            Class<?> type = base.getClass();
            try {
                Field field = type.getField(pseudoField);
                field.set(base, ConvertUtility.convert(field.getType(), value));
            }
            catch (NoSuchFieldException | SecurityException ex) {
                String methodName = BeanHelper.setter(pseudoField);
                for (Method method : type.getMethods()) {
                    Class<?>[] paramTypes;
                    if (!methodName.equals(method.getName()) || (paramTypes = method.getParameterTypes()).length != 1) continue;
                    method.invoke(base, ConvertUtility.convert(paramTypes[0], value));
                    return;
                }
                throw new BeanHelperException("no setter for", base, pseudoField);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new BeanHelperException(base, pseudoField, (Throwable)ex);
        }
    }

    public static final Object getExpValue(Object base, String expression) throws BeanHelperException {
        try {
            Object value = null;
            Matcher mm = FIELDEXPR.matcher(expression);
            if (mm.matches()) {
                String name = mm.group(1);
                value = BeanHelper.getFieldValue(base, name);
            } else {
                mm = METHODEXPR.matcher(expression);
                if (mm.matches()) {
                    String name = mm.group(1);
                    Method mth = base.getClass().getMethod(name, new Class[0]);
                    value = mth.invoke(base, new Object[0]);
                } else {
                    value = expression;
                }
            }
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new BeanHelperException(base, expression, (Throwable)ex);
        }
    }

    public static final void setExpValue(Object base, String expression, Object value) throws BeanHelperException, ConvertUtilityException {
        try {
            Matcher mm = FIELDEXPR.matcher(expression);
            if (mm.matches()) {
                String name = mm.group(1);
                BeanHelper.setFieldValue(base, name, value);
            } else {
                mm = METHODEXPR.matcher(expression);
                if (mm.matches()) {
                    String name = mm.group(1);
                    Method mth = base.getClass().getMethod(name, value.getClass());
                    mth.invoke(base, value);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new BeanHelperException(base, expression, (Throwable)ex);
        }
    }

    public static final Object invoke(Object base, String expression) throws BeanHelperException {
        try {
            Method method = BeanHelper.getMethod(base, expression);
            return method.invoke(base, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            throw new BeanHelperException(base, expression, (Throwable)ex);
        }
    }

    public static final Object invoke(Object base, Method method) throws BeanHelperException {
        try {
            return method.invoke(base, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new BeanHelperException(base, method, (Throwable)ex);
        }
    }

    public static final Method getMethod(Object base, String pseudoField) throws BeanHelperException {
        try {
            Matcher mm = FIELD.matcher(pseudoField);
            if (mm.matches()) {
                try {
                    String name = BeanHelper.getter(mm.group(1));
                    return base.getClass().getMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    String name = BeanHelper.isser(mm.group(1));
                    return base.getClass().getMethod(name, new Class[0]);
                }
            }
            mm = METHOD.matcher(pseudoField);
            if (mm.matches()) {
                String name = mm.group(1);
                return base.getClass().getMethod(name, new Class[0]);
            }
            throw new BeanHelperException("method not found for" + base.getClass().getName() + "." + pseudoField);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException ex) {
            throw new BeanHelperException(base, pseudoField, (Throwable)ex);
        }
    }

    public static final Field getField(Class clazz, String name) throws BeanHelperException {
        NoSuchFieldException ex = null;
        for (Class sc = clazz; sc != null; sc = sc.getSuperclass()) {
            try {
                return sc.getDeclaredField(name);
            }
            catch (NoSuchFieldException ex1) {
                ex = ex1;
                continue;
            }
        }
        throw new BeanHelperException(clazz, name, (Throwable)ex);
    }

    public static final boolean isArrayType(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return true;
        }
        return object instanceof List;
    }

    public static final Collection getObjectCollection(Object object) throws BeanHelperException {
        if (object == null) {
            return new HashSet();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object.getClass().isArray()) {
            HashSet set = new HashSet();
            Object[] arr = (Object[])object;
            Collections.addAll(set, arr);
            return set;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(object);
        return set;
    }

    public static final Object[] castArray(Object[] arr, Object[] object) {
        assert (arr.length == object.length);
        System.arraycopy(object, 0, arr, 0, arr.length);
        return arr;
    }

    public static final Object[] getObjectArray(Object object) throws BeanHelperException, ConvertUtilityException {
        if (object == null) {
            return new Object[]{null};
        }
        return BeanHelper.getObjectArray(object.getClass(), object);
    }

    public static final Object[] getObjectArray(Class type, Object object) throws BeanHelperException, ConvertUtilityException {
        if (type.isArray()) {
            return (Object[])ConvertUtility.convert(Object.class, object);
        }
        if (type.isEnum()) {
            try {
                Method values = type.getMethod("values", new Class[0]);
                return (Object[])values.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new BeanHelperException("Enum", (Throwable)ex);
            }
        }
        if (object == null) {
            return new Object[0];
        }
        if (object instanceof List) {
            List list = (List)object;
            return list.toArray();
        }
        return new Object[]{object};
    }

    public static final String getter(Field field, String fieldName) {
        Class<?> type = field.getType();
        if (type.isPrimitive() && "boolean".equals(type.getName())) {
            return BeanHelper.isser(fieldName);
        }
        return BeanHelper.getter(fieldName);
    }

    public static final String getter(String fieldName) {
        return "get" + BeanHelper.upper(fieldName);
    }

    public static final String isser(String fieldName) {
        return "is" + BeanHelper.upper(fieldName);
    }

    public static final String setter(String field) {
        return "set" + BeanHelper.upper(field);
    }

    public static final String field(String etter) {
        if (etter.startsWith("get") || etter.startsWith("set")) {
            etter = etter.substring(3);
        }
        return BeanHelper.lower(etter);
    }

    private static String lower(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    private static String upper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static final String getField(Method method) {
        return BeanHelper.field(method.getName());
    }

    public static final Set<String> getFields(Class<?> cls) {
        HashSet<String> set = new HashSet<String>();
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterCount() != 0 || Void.class.equals(method.getReturnType())) continue;
            set.add(BeanHelper.getField(method));
        }
        for (AccessibleObject accessibleObject : cls.getFields()) {
            set.add(((Field)accessibleObject).getName());
        }
        return set;
    }
}

