/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpvisit.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.tinygroup.commons.file.IOUtils;
import org.tinygroup.httpvisit.HttpVisitor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpVisitorImpl
implements HttpVisitor {
    private static final Logger logger = LoggerFactory.getLogger(HttpVisitorImpl.class);
    HttpClient client;
    private String responseCharset = "UTF-8";
    private String requestCharset = "ISO-8859-1";
    int timeout = 30000;
    HttpState httpState = new HttpState();
    boolean authEnabled = false;
    List<String> authPrefs = null;
    private String proxyHost;
    private int proxyPort;
    private UsernamePasswordCredentials proxyUserPassword;
    private Map<String, String> headerMap = new HashMap<String, String>();

    public HttpVisitorImpl() {
        this.headerMap.put("Accept", "text/html, application/xhtml+xml, */*");
        this.headerMap.put("Accept-Language", "zh-CN,en-US;q=0.5");
        this.headerMap.put("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
        this.headerMap.put("Accept-Encoding", "gzip, deflate");
        this.headerMap.put("Host", "localhost:9999");
        this.headerMap.put("Connection", "Keep-Alive");
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String userName, String passwrod) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        if (userName != null) {
            this.proxyUserPassword = new UsernamePasswordCredentials("my-proxy-username", "my-proxy-password");
        }
    }

    @Override
    public void setBasicAuth(String host, int port, String realm, String schema, String username, String password) {
        this.httpState.setCredentials(new AuthScope("www.verisign.com", 443, realm, schema), (Credentials)new UsernamePasswordCredentials("username", "password"));
        this.authEnabled = true;
    }

    @Override
    public void setBasicAuth(String host, int port, String username, String password) {
        this.setBasicAuth(host, port, username, password);
    }

    @Override
    public void setAlternateAuth(String host, int port, String username, String password, List<String> schemaList) {
        this.httpState.setCredentials(new AuthScope("www.verisign.com", 443), (Credentials)new UsernamePasswordCredentials("username", "password"));
        this.authEnabled = true;
        this.client.getParams().setParameter("http.auth.scheme-priority", schemaList);
    }

    public String getRequestCharset() {
        return this.requestCharset;
    }

    @Override
    public void setRequestCharset(String requestCharset) {
        this.requestCharset = requestCharset;
    }

    public String getResponseCharset() {
        return this.responseCharset;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void init() {
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.timeout);
        this.client.getParams().setCookiePolicy("rfc2109");
        this.client.setState(this.httpState);
        if (this.authPrefs != null) {
            this.client.getParams().setParameter("http.auth.scheme-priority", this.authPrefs);
        }
        if (this.proxyHost != null) {
            this.client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            if (this.proxyUserPassword != null) {
                this.httpState.setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)this.proxyUserPassword);
            }
        }
    }

    @Override
    public String getUrl(String url, Map<String, ?> parameter) {
        try {
            StringBuffer sb = new StringBuffer(url);
            if (parameter != null) {
                if (url.indexOf(63) < 0) {
                    sb.append("?");
                }
                for (String key : parameter.keySet()) {
                    Object value = parameter.get(key);
                    if (value.getClass().isArray()) {
                        Object[] arrayValue;
                        for (Object o : arrayValue = (Object[])value) {
                            this.appendParameter(sb, key, o);
                        }
                        continue;
                    }
                    this.appendParameter(sb, key, value);
                }
            }
            GetMethod get = new GetMethod(sb.toString());
            this.addHeader((HttpMethodBase)get, this.headerMap);
            return this.execute((HttpMethodBase)get);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendParameter(StringBuffer sb, String key, Object value) throws UnsupportedEncodingException {
        sb.append("&");
        sb.append(URLEncoder.encode(key, this.requestCharset));
        sb.append("=");
        sb.append(URLEncoder.encode(value.toString(), this.requestCharset));
    }

    @Override
    public String postUrl(String url, Map<String, ?> parameter) {
        PostMethod post = new PostMethod(url);
        if (parameter != null) {
            for (String key : parameter.keySet()) {
                Object value = parameter.get(key);
                if (value.getClass().isArray()) {
                    Object[] arrayValue;
                    for (Object o : arrayValue = (Object[])value) {
                        post.addParameter(key, o.toString());
                    }
                    continue;
                }
                post.setParameter(key, value.toString());
            }
        }
        this.addHeader((HttpMethodBase)post, this.headerMap);
        return this.execute((HttpMethodBase)post);
    }

    String execute(HttpMethodBase method) {
        try {
            if (this.client == null) {
                this.init();
            }
            logger.logMessage(LogLevel.DEBUG, "\u6b63\u5728\u8bbf\u95ee\u5730\u5740:{}", new Object[]{method.getURI().toString()});
            if (!this.requestCharset.equals("ISO-8859-1")) {
                method.addRequestHeader("Content-Type", "text/html; charset=" + this.requestCharset);
            }
            method.setDoAuthentication(this.authEnabled);
            int iGetResultCode = this.client.executeMethod((HttpMethod)method);
            if (iGetResultCode == 200) {
                String acceptEncoding;
                logger.logMessage(LogLevel.DEBUG, "\u7ed3\u679c\u6210\u529f\u8fd4\u56de\u3002");
                Header responseHeader = method.getResponseHeader("Content-Encoding");
                if (responseHeader != null && (acceptEncoding = responseHeader.getValue()) != null && acceptEncoding.equals("gzip")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(method.getResponseBody());
                    GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
                    String string = IOUtils.readFromInputStream((InputStream)gzipInputStream, (String)this.responseCharset);
                    return string;
                }
                String string = new String(method.getResponseBody(), this.responseCharset);
                return string;
            }
            try {
                logger.logMessage(LogLevel.ERROR, "\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{method.getStatusLine().toString()});
                throw new RuntimeException(method.getStatusLine().toString());
            }
            catch (Exception e) {
                logger.logMessage(LogLevel.DEBUG, "\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{e.getMessage()});
                throw new RuntimeException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void setResponseCharset(String charset) {
        this.responseCharset = charset;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.httpState.addCookie(cookie);
    }

    @Override
    public Cookie[] getCookies() {
        return this.httpState.getCookies();
    }

    @Override
    public String postSoap(String url, String soapAction, String xmlEntiry) {
        PostMethod post = new PostMethod(url);
        try {
            StringRequestEntity entity = new StringRequestEntity(xmlEntiry, null, null);
            post.setRequestEntity((RequestEntity)entity);
            if (soapAction != null) {
                post.setRequestHeader("SOAPAction", soapAction);
            }
            this.addHeader((HttpMethodBase)post, this.headerMap);
            String string = this.execute((HttpMethodBase)post);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public String postSoap(String url, String xmlEntiry) {
        return this.postSoap(url, null, xmlEntiry);
    }

    @Override
    public String postXml(String url, String xmlEntiry) {
        PostMethod post = new PostMethod(url);
        try {
            post.setDoAuthentication(this.authEnabled);
            StringRequestEntity entity = new StringRequestEntity(xmlEntiry, null, null);
            post.setRequestEntity((RequestEntity)entity);
            this.addHeader((HttpMethodBase)post, this.headerMap);
            String string = this.execute((HttpMethodBase)post);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public void setHeaderMap(Map<String, String> headerMap) {
        this.headerMap.putAll(headerMap);
    }

    @Override
    public HttpVisitor setHeader(String key, String value) {
        this.headerMap.put(key, value);
        return this;
    }

    private void addHeader(HttpMethodBase method, Map<String, String> header) {
        if (header != null) {
            for (String key : header.keySet()) {
                Header h = new Header(key, header.get(key));
                method.addRequestHeader(h);
            }
        }
    }

    @Override
    public void addCookie(Cookie[] cookies) {
        this.httpState.addCookies(cookies);
    }

    @Override
    public HttpState getHttpState() {
        return this.client.getState();
    }
}

