/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.Clock;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.Era;
import org.threeten.bp.temporal.ISOEra;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.ValueRange;

public final class ISOChrono
extends Chrono<ISOChrono>
implements Serializable {
    public static final ISOChrono INSTANCE = new ISOChrono();
    public static final Era<ISOChrono> ERA_BCE = ISOEra.BCE;
    public static final Era<ISOChrono> ERA_CE = ISOEra.CE;
    private static final long serialVersionUID = -1440403870442975015L;

    private ISOChrono() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "ISO";
    }

    @Override
    public String getCalendarType() {
        return "iso8601";
    }

    public LocalDate date(Era<ISOChrono> era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    public LocalDate date(int prolepticYear, int month, int dayOfMonth) {
        return LocalDate.of(prolepticYear, month, dayOfMonth);
    }

    public LocalDate dateYearDay(Era<ISOChrono> era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    public LocalDate dateYearDay(int prolepticYear, int dayOfYear) {
        return LocalDate.ofYearDay(prolepticYear, dayOfYear);
    }

    public LocalDate date(TemporalAccessor temporal) {
        return LocalDate.from(temporal);
    }

    public LocalDateTime localDateTime(TemporalAccessor temporal) {
        return LocalDateTime.from(temporal);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporal) {
        return ZonedDateTime.from(temporal);
    }

    public LocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    public LocalDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    public LocalDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        return (prolepticYear & 3L) == 0L && (prolepticYear % 100L != 0L || prolepticYear % 400L == 0L);
    }

    @Override
    public int prolepticYear(Era<ISOChrono> era, int yearOfEra) {
        if (!(era instanceof ISOEra)) {
            throw new DateTimeException("Era must be ISOEra");
        }
        return era == ISOEra.CE ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public Era<ISOChrono> eraOf(int eraValue) {
        return ISOEra.of(eraValue);
    }

    @Override
    public List<Era<ISOChrono>> eras() {
        return Arrays.asList(ISOEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        return field.range();
    }
}

