/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.temporal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.jdk8.DefaultInterfaceChronoZonedDateTime;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDateTime;
import org.threeten.bp.temporal.ChronoLocalDateTimeImpl;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.ChronoZonedDateTime;
import org.threeten.bp.temporal.Ser;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.zone.ZoneOffsetTransition;
import org.threeten.bp.zone.ZoneRules;

final class ChronoZonedDateTimeImpl<C extends Chrono<C>>
extends DefaultInterfaceChronoZonedDateTime<C>
implements ChronoZonedDateTime<C>,
Serializable {
    private static final long serialVersionUID = -5261813987200935591L;
    private final ChronoLocalDateTimeImpl<C> dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    static <R extends Chrono<R>> ChronoZonedDateTime<R> ofBest(ChronoLocalDateTimeImpl<R> localDateTime, ZoneId zone, ZoneOffset preferredOffset) {
        ZoneOffset offset;
        LocalDateTime isoLDT;
        Objects.requireNonNull(localDateTime, "localDateTime");
        Objects.requireNonNull(zone, "zone");
        if (zone instanceof ZoneOffset) {
            return new ChronoZonedDateTimeImpl<R>(localDateTime, (ZoneOffset)zone, zone);
        }
        ZoneRules rules = zone.getRules();
        List<ZoneOffset> validOffsets = rules.getValidOffsets(isoLDT = LocalDateTime.from(localDateTime));
        if (validOffsets.size() == 1) {
            offset = validOffsets.get(0);
        } else if (validOffsets.size() == 0) {
            ZoneOffsetTransition trans = rules.getTransition(isoLDT);
            localDateTime = localDateTime.plusSeconds(trans.getDuration().getSeconds());
            offset = trans.getOffsetAfter();
        } else {
            offset = preferredOffset != null && validOffsets.contains(preferredOffset) ? preferredOffset : validOffsets.get(0);
        }
        Objects.requireNonNull(offset, "offset");
        return new ChronoZonedDateTimeImpl<R>(localDateTime, offset, zone);
    }

    static <R extends Chrono<R>> ChronoZonedDateTimeImpl<R> ofInstant(Chrono<R> chrono, Instant instant, ZoneId zone) {
        ZoneRules rules = zone.getRules();
        ZoneOffset offset = rules.getOffset(instant);
        Objects.requireNonNull(offset, "offset");
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
        ChronoLocalDateTimeImpl cldt = (ChronoLocalDateTimeImpl)chrono.localDateTime(ldt);
        return new ChronoZonedDateTimeImpl(cldt, offset, zone);
    }

    private ChronoZonedDateTimeImpl<C> create(Instant instant, ZoneId zone) {
        return ChronoZonedDateTimeImpl.ofInstant(this.getDate().getChrono(), instant, zone);
    }

    private ChronoZonedDateTimeImpl(ChronoLocalDateTimeImpl<C> dateTime, ZoneOffset offset, ZoneId zone) {
        this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
        this.offset = Objects.requireNonNull(offset, "offset");
        this.zone = Objects.requireNonNull(zone, "zone");
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    @Override
    public ChronoZonedDateTime<C> withEarlierOffsetAtOverlap() {
        ZoneOffset earlierOffset;
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (trans != null && trans.isOverlap() && !(earlierOffset = trans.getOffsetBefore()).equals(this.offset)) {
            return new ChronoZonedDateTimeImpl<C>(this.dateTime, earlierOffset, this.zone);
        }
        return this;
    }

    @Override
    public ChronoZonedDateTime<C> withLaterOffsetAtOverlap() {
        ZoneOffset offset;
        ZoneOffsetTransition trans = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (trans != null && !(offset = trans.getOffsetAfter()).equals(this.getOffset())) {
            return new ChronoZonedDateTimeImpl<C>(this.dateTime, offset, this.zone);
        }
        return this;
    }

    @Override
    public ChronoLocalDateTime<C> getDateTime() {
        return this.dateTime;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public ChronoZonedDateTime<C> withZoneSameLocal(ZoneId zone) {
        return ChronoZonedDateTimeImpl.ofBest(this.dateTime, zone, this.offset);
    }

    @Override
    public ChronoZonedDateTime<C> withZoneSameInstant(ZoneId zone) {
        Objects.requireNonNull(zone, "zone");
        return this.zone.equals(zone) ? this : this.create(this.dateTime.toInstant(this.offset), zone);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        return field instanceof ChronoField || field != null && field.doIsSupported(this);
    }

    @Override
    public ChronoZonedDateTime<C> with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            switch (f) {
                case INSTANT_SECONDS: {
                    return this.plus(newValue - this.toEpochSecond(), ChronoUnit.SECONDS);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset offset = ZoneOffset.ofTotalSeconds(f.checkValidIntValue(newValue));
                    return this.create(this.dateTime.toInstant(offset), this.zone);
                }
            }
            return ChronoZonedDateTimeImpl.ofBest(this.dateTime.with(field, newValue), this.zone, this.offset);
        }
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(field.doWith(this, newValue));
    }

    @Override
    public ChronoZonedDateTime<C> plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(amountToAdd, unit));
        }
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(unit.doPlus(this, amountToAdd));
    }

    @Override
    public long periodUntil(Temporal endDateTime, TemporalUnit unit) {
        if (!(endDateTime instanceof ChronoZonedDateTime)) {
            throw new DateTimeException("Unable to calculate period between objects of two different types");
        }
        ChronoZonedDateTime end = (ChronoZonedDateTime)endDateTime;
        if (!((Chrono)this.getDate().getChrono()).equals(end.getDate().getChrono())) {
            throw new DateTimeException("Unable to calculate period between two different chronologies");
        }
        if (unit instanceof ChronoUnit) {
            end = end.withZoneSameInstant(this.offset);
            return this.dateTime.periodUntil(end.getDateTime(), unit);
        }
        return unit.between(this, endDateTime).getAmount();
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dateTime);
        out.writeObject(this.offset);
        out.writeObject(this.zone);
    }

    static ChronoZonedDateTime<?> readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ChronoLocalDateTime dateTime = (ChronoLocalDateTime)in.readObject();
        ZoneOffset offset = (ZoneOffset)in.readObject();
        ZoneId zone = (ZoneId)in.readObject();
        return dateTime.atZone(offset).withZoneSameLocal(zone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = this.getDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            str = str + '[' + this.getZone().toString() + ']';
        }
        return str;
    }
}

