/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

import java.util.Objects;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.jdk8.DefaultInterfaceTemporal;
import org.threeten.bp.temporal.Chrono;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoLocalDate;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.ChronoZonedDateTime;
import org.threeten.bp.temporal.TemporalAdder;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.TemporalSubtractor;
import org.threeten.bp.temporal.TemporalUnit;
import org.threeten.bp.temporal.ValueRange;

public abstract class DefaultInterfaceChronoZonedDateTime<C extends Chrono<C>>
extends DefaultInterfaceTemporal
implements ChronoZonedDateTime<C> {
    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (field == ChronoField.INSTANT_SECONDS || field == ChronoField.OFFSET_SECONDS) {
                return field.range();
            }
            return this.getDateTime().range(field);
        }
        return field.doRange(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    throw new DateTimeException("Field too large for an int: " + field);
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.getDateTime().get(field);
        }
        return super.get(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.getDateTime().getLong(field);
        }
        return field.doGet(this);
    }

    @Override
    public ChronoLocalDate<C> getDate() {
        return this.getDateTime().getDate();
    }

    @Override
    public LocalTime getTime() {
        return this.getDateTime().getTime();
    }

    @Override
    public ChronoZonedDateTime<C> with(TemporalAdjuster adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(super.with(adjuster));
    }

    @Override
    public ChronoZonedDateTime<C> plus(TemporalAdder adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(super.plus(adjuster));
    }

    @Override
    public ChronoZonedDateTime<C> minus(TemporalSubtractor adjuster) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(super.minus(adjuster));
    }

    @Override
    public ChronoZonedDateTime<C> minus(long amountToSubtract, TemporalUnit unit) {
        return ((Chrono)this.getDate().getChrono()).ensureChronoZonedDateTime(super.minus(amountToSubtract, unit));
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.zoneId()) {
            return (R)this.getZone();
        }
        if (query == TemporalQueries.chrono()) {
            return (R)this.getDate().getChrono();
        }
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (query == TemporalQueries.offset()) {
            return (R)this.getOffset();
        }
        return super.query(query);
    }

    @Override
    public Instant toInstant() {
        return Instant.ofEpochSecond(this.toEpochSecond(), this.getTime().getNano());
    }

    @Override
    public long toEpochSecond() {
        long epochDay = this.getDate().toEpochDay();
        long secs = epochDay * 86400L + (long)this.getTime().toSecondOfDay();
        return secs -= (long)this.getOffset().getTotalSeconds();
    }

    @Override
    public int compareTo(ChronoZonedDateTime<?> other) {
        int cmp = Long.compare(this.toEpochSecond(), other.toEpochSecond());
        if (cmp == 0 && (cmp = this.getTime().getNano() - other.getTime().getNano()) == 0 && (cmp = this.getDateTime().compareTo(other.getDateTime())) == 0 && (cmp = this.getZone().getId().compareTo(other.getZone().getId())) == 0) {
            cmp = ((Chrono)this.getDate().getChrono()).compareTo((Chrono<?>)other.getDate().getChrono());
        }
        return cmp;
    }

    @Override
    public boolean isAfter(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec > (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.getTime().getNano() > other.getTime().getNano();
    }

    @Override
    public boolean isBefore(ChronoZonedDateTime<?> other) {
        long otherEpochSec;
        long thisEpochSec = this.toEpochSecond();
        return thisEpochSec < (otherEpochSec = other.toEpochSecond()) || thisEpochSec == otherEpochSec && this.getTime().getNano() < other.getTime().getNano();
    }

    @Override
    public boolean isEqual(ChronoZonedDateTime<?> other) {
        return this.toEpochSecond() == other.toEpochSecond() && this.getTime().getNano() == other.getTime().getNano();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String str = this.getDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            str = str + '[' + this.getZone().toString() + ']';
        }
        return str;
    }

    @Override
    public String toString(DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter, "formatter");
        return formatter.print(this);
    }
}

