/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp;

import org.threeten.bp.Period;
import org.threeten.bp.format.DateTimeParseException;

final class PeriodParser {
    private static final String TOKEN_SEQUENCE = "PYMDTHMS";
    private static final String ZERO = "PT0S";
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private long nanos;
    private boolean negativeSecs;
    private int index;
    private CharSequence text;

    PeriodParser(CharSequence text) {
        this.text = text;
    }

    Period parse() {
        String s = this.text.toString().toUpperCase().replace(',', '.');
        if (ZERO.equals(s)) {
            return Period.ZERO;
        }
        if (s.length() < 3 || s.charAt(0) != 'P') {
            throw new DateTimeParseException("Period could not be parsed: " + this.text, this.text, 0);
        }
        this.validateCharactersAndOrdering(s, this.text);
        String[] datetime = s.substring(1).split("T");
        switch (datetime.length) {
            case 2: {
                this.parseDate(datetime[0], 1);
                this.parseTime(datetime[1], datetime[0].length() + 2);
                break;
            }
            case 1: {
                this.parseDate(datetime[0], 1);
            }
        }
        return this.toPeriod();
    }

    private void parseDate(String s, int baseIndex) {
        this.index = 0;
        while (this.index < s.length()) {
            String value = this.parseNumber(s);
            if (this.index >= s.length()) continue;
            char c = s.charAt(this.index);
            switch (c) {
                case 'Y': {
                    this.years = this.parseInt(value, baseIndex);
                    break;
                }
                case 'M': {
                    this.months = this.parseInt(value, baseIndex);
                    break;
                }
                case 'D': {
                    this.days = this.parseInt(value, baseIndex);
                    break;
                }
                default: {
                    throw new DateTimeParseException("Period could not be parsed, unrecognized letter '" + c + ": " + this.text, this.text, baseIndex + this.index);
                }
            }
            ++this.index;
        }
    }

    private void parseTime(String s, int baseIndex) {
        this.index = 0;
        s = this.prepareTime(s, baseIndex);
        while (this.index < s.length()) {
            String value = this.parseNumber(s);
            if (this.index >= s.length()) continue;
            char c = s.charAt(this.index);
            switch (c) {
                case 'H': {
                    this.hours = this.parseInt(value, baseIndex);
                    break;
                }
                case 'M': {
                    this.minutes = this.parseInt(value, baseIndex);
                    break;
                }
                case 'S': {
                    this.seconds = this.parseInt(value, baseIndex);
                    break;
                }
                case 'N': {
                    this.nanos = this.parseNanos(value, baseIndex);
                    break;
                }
                default: {
                    throw new DateTimeParseException("Period could not be parsed, unrecognized letter '" + c + "': " + this.text, this.text, baseIndex + this.index);
                }
            }
            ++this.index;
        }
    }

    private long parseNanos(String s, int baseIndex) {
        if (s.length() > 9) {
            throw new DateTimeParseException("Period could not be parsed, nanosecond range exceeded: " + this.text, this.text, baseIndex + this.index - s.length());
        }
        return Long.parseLong((s + "000000000").substring(0, 9));
    }

    private String prepareTime(String s, int baseIndex) {
        if (s.contains(".")) {
            int i = s.indexOf(".") + 1;
            if (Character.isDigit(s.charAt(i))) {
                ++i;
            } else {
                throw new DateTimeParseException("Period could not be parsed, invalid decimal number: " + this.text, this.text, baseIndex + this.index);
            }
            while (i < s.length()) {
                char c = s.charAt(i);
                if (Character.isDigit(c) || c == 'S') {
                    ++i;
                    continue;
                }
                throw new DateTimeParseException("Period could not be parsed, invalid decimal number: " + this.text, this.text, baseIndex + this.index);
            }
            if ((s = s.replace('S', 'N').replace('.', 'S')).contains("-0S")) {
                this.negativeSecs = true;
                s = s.replace("-0S", "0S");
            }
        }
        return s;
    }

    private int parseInt(String s, int baseIndex) {
        try {
            int value = Integer.parseInt(s);
            if (s.charAt(0) == '-' && value == 0) {
                throw new DateTimeParseException("Period could not be parsed, invalid number '" + s + "': " + this.text, this.text, baseIndex + this.index - s.length());
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new DateTimeParseException("Period could not be parsed, invalid number '" + s + "': " + this.text, this.text, baseIndex + this.index - s.length());
        }
    }

    private String parseNumber(String s) {
        char c;
        int start = this.index;
        while (this.index < s.length() && ((c = s.charAt(this.index)) >= '0' && c <= '9' || c == '-')) {
            ++this.index;
        }
        return s.substring(start, this.index);
    }

    private void validateCharactersAndOrdering(String s, CharSequence text) {
        char[] chars = s.toCharArray();
        int tokenPos = 0;
        boolean lastLetter = false;
        for (int i = 0; i < chars.length; ++i) {
            if (tokenPos >= TOKEN_SEQUENCE.length()) {
                throw new DateTimeParseException("Period could not be parsed, characters after last 'S': " + text, text, i);
            }
            char c = chars[i];
            if ((c < '0' || c > '9') && c != '-' && c != '.') {
                if ((tokenPos = TOKEN_SEQUENCE.indexOf(c, tokenPos)) < 0) {
                    throw new DateTimeParseException("Period could not be parsed, invalid character '" + c + "': " + text, text, i);
                }
                ++tokenPos;
                lastLetter = true;
                continue;
            }
            lastLetter = false;
        }
        if (!lastLetter) {
            throw new DateTimeParseException("Period could not be parsed, invalid last character: " + text, text, s.length() - 1);
        }
    }

    private Period toPeriod() {
        return Period.of(this.years, this.months, this.days, this.hours, this.minutes, this.seconds, this.negativeSecs || this.seconds < 0 ? -this.nanos : this.nanos);
    }
}

