/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import org.testfx.robot.BaseRobot;
import org.testfx.service.adapter.RobotAdapter;
import org.testfx.service.adapter.impl.AwtRobotAdapter;
import org.testfx.service.adapter.impl.GlassRobotAdapter;
import org.testfx.service.adapter.impl.JavafxRobotAdapter;

public class BaseRobotImpl
implements BaseRobot {
    private final RobotAdapter robotAdapter;
    private final JavafxRobotAdapter javafxRobotAdapter;

    public BaseRobotImpl() {
        String robotAdapterName;
        boolean verbose = Boolean.getBoolean("testfx.verbose");
        switch (robotAdapterName = System.getProperty("testfx.robot", "glass")) {
            case "awt": {
                if (verbose) {
                    System.out.println("testfx: initializing AWT robot");
                }
                this.robotAdapter = new AwtRobotAdapter();
                break;
            }
            case "glass": {
                if (verbose) {
                    System.out.println("testfx: initializing Glass robot");
                }
                this.robotAdapter = GlassRobotAdapter.createGlassRobot();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("unknown robot adapter 'testfx.robot=%s' (must be 'awt' or 'glass')", robotAdapterName));
            }
        }
        this.javafxRobotAdapter = new JavafxRobotAdapter();
    }

    @Override
    public void pressKeyboard(KeyCode key) {
        this.robotAdapter.keyPress(key);
    }

    @Override
    public void releaseKeyboard(KeyCode key) {
        this.robotAdapter.keyRelease(key);
    }

    @Override
    public void typeKeyboard(Scene scene, KeyCode key, String character) {
        this.javafxRobotAdapter.robotCreate(scene);
        this.javafxRobotAdapter.keyPress(key);
        this.javafxRobotAdapter.keyType(KeyCode.UNDEFINED, character);
        this.javafxRobotAdapter.keyRelease(key);
    }

    @Override
    public Point2D retrieveMouse() {
        return this.robotAdapter.getMouseLocation();
    }

    @Override
    public void moveMouse(Point2D point) {
        this.robotAdapter.mouseMove(point);
    }

    @Override
    public void scrollMouse(int amount) {
        this.robotAdapter.mouseWheel(amount);
    }

    @Override
    public void pressMouse(MouseButton button) {
        this.robotAdapter.mousePress(button);
    }

    @Override
    public void releaseMouse(MouseButton button) {
        this.robotAdapter.mouseRelease(button);
    }

    @Override
    public Image captureRegion(Rectangle2D region) {
        return this.robotAdapter.getCaptureRegion(region);
    }
}

