/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;

public class Db2Container
extends JdbcDatabaseContainer<Db2Container> {
    public static final String NAME = "db2";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"ibmcom/db2");
    @Deprecated
    public static final String DEFAULT_DB2_IMAGE_NAME = DEFAULT_IMAGE_NAME.getUnversionedPart();
    @Deprecated
    public static final String DEFAULT_TAG = "11.5.0.0a";
    public static final int DB2_PORT = 50000;
    private String databaseName = "test";
    private String username = "db2inst1";
    private String password = "foobar1234";

    @Deprecated
    public Db2Container() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public Db2Container(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public Db2Container(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withPrivilegedMode(true);
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*Setup has completed\\..*").withStartupTimeout(Duration.of(10L, ChronoUnit.MINUTES));
        this.addExposedPort(50000);
    }

    protected Set<Integer> getLivenessCheckPorts() {
        return new HashSet<Integer>(this.getMappedPort(50000));
    }

    protected void configure() {
        if (!this.getEnvMap().containsKey("LICENSE")) {
            LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
            this.acceptLicense();
        }
        this.addEnv("DBNAME", this.databaseName);
        this.addEnv("DB2INSTANCE", this.username);
        this.addEnv("DB2INST1_PASSWORD", this.password);
        if (!this.getEnvMap().containsKey("AUTOCONFIG")) {
            this.addEnv("AUTOCONFIG", "false");
        }
        if (!this.getEnvMap().containsKey("ARCHIVE_LOGS")) {
            this.addEnv("ARCHIVE_LOGS", "false");
        }
    }

    public Db2Container acceptLicense() {
        this.addEnv("LICENSE", "accept");
        return this;
    }

    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters(":", ";", ";");
        return "jdbc:db2://" + this.getHost() + ":" + this.getMappedPort(50000) + "/" + this.databaseName + additionalUrlParams;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Db2Container withUsername(String username) {
        this.username = username;
        return this;
    }

    public Db2Container withPassword(String password) {
        this.password = password;
        return this;
    }

    public Db2Container withDatabaseName(String dbName) {
        this.databaseName = dbName;
        return this;
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    protected String getTestQueryString() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }
}

