/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BlockLSTMV2<T extends Number>
extends PrimitiveOp {
    private Output<T> i;
    private Output<T> cs;
    private Output<T> f;
    private Output<T> o;
    private Output<T> ci;
    private Output<T> co;
    private Output<T> h;

    public static <T extends Number> BlockLSTMV2<T> create(Scope scope, Operand<Long> seqLenMax, Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BlockLSTMV2", scope.makeOpName("BlockLSTMV2"));
        opBuilder.addInput(seqLenMax.asOutput());
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(csPrev.asOutput());
        opBuilder.addInput(hPrev.asOutput());
        opBuilder.addInput(w.asOutput());
        opBuilder.addInput(wci.asOutput());
        opBuilder.addInput(wcf.asOutput());
        opBuilder.addInput(wco.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.cellClip != null) {
                    opBuilder.setAttr("cell_clip", opts.cellClip.floatValue());
                }
                if (opts.usePeephole == null) continue;
                opBuilder.setAttr("use_peephole", opts.usePeephole);
            }
        }
        return new BlockLSTMV2<T>(opBuilder.build());
    }

    public static Options cellClip(Float cellClip) {
        return new Options().cellClip(cellClip);
    }

    public static Options usePeephole(Boolean usePeephole) {
        return new Options().usePeephole(usePeephole);
    }

    public Output<T> i() {
        return this.i;
    }

    public Output<T> cs() {
        return this.cs;
    }

    public Output<T> f() {
        return this.f;
    }

    public Output<T> o() {
        return this.o;
    }

    public Output<T> ci() {
        return this.ci;
    }

    public Output<T> co() {
        return this.co;
    }

    public Output<T> h() {
        return this.h;
    }

    private BlockLSTMV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.i = operation.output(outputIdx++);
        this.cs = operation.output(outputIdx++);
        this.f = operation.output(outputIdx++);
        this.o = operation.output(outputIdx++);
        this.ci = operation.output(outputIdx++);
        this.co = operation.output(outputIdx++);
        this.h = operation.output(outputIdx++);
    }

    public static class Options {
        private Float cellClip;
        private Boolean usePeephole;

        public Options cellClip(Float cellClip) {
            this.cellClip = cellClip;
            return this;
        }

        public Options usePeephole(Boolean usePeephole) {
            this.usePeephole = usePeephole;
            return this;
        }

        private Options() {
        }
    }
}

