/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.quantization.Dequantize;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgs;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxArgsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVars;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsGradient;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannel;
import org.tensorflow.op.quantization.FakeQuantWithMinMaxVarsPerChannelGradient;
import org.tensorflow.op.quantization.Quantize;
import org.tensorflow.op.quantization.QuantizeAndDequantize;
import org.tensorflow.op.quantization.QuantizeDownAndShrinkRange;
import org.tensorflow.op.quantization.RequantizationRange;
import org.tensorflow.op.quantization.Requantize;

public final class QuantizationOps {
    private final Scope scope;

    QuantizationOps(Scope scope) {
        this.scope = scope;
    }

    public FakeQuantWithMinMaxVarsPerChannelGradient fakeQuantWithMinMaxVarsPerChannelGradient(Operand<Float> gradients, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, FakeQuantWithMinMaxVarsPerChannelGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannelGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public <T> Dequantize dequantize(Operand<T> input, Operand<Float> minRange, Operand<Float> maxRange, Dequantize.Options ... options) {
        return Dequantize.create(this.scope, input, minRange, maxRange, options);
    }

    public FakeQuantWithMinMaxVarsGradient fakeQuantWithMinMaxVarsGradient(Operand<Float> gradients, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, FakeQuantWithMinMaxVarsGradient.Options ... options) {
        return FakeQuantWithMinMaxVarsGradient.create(this.scope, gradients, inputs, min, max, options);
    }

    public <U, T> QuantizeDownAndShrinkRange<U> quantizeDownAndShrinkRange(Operand<T> input, Operand<Float> inputMin, Operand<Float> inputMax, Class<U> outType) {
        return QuantizeDownAndShrinkRange.create(this.scope, input, inputMin, inputMax, outType);
    }

    public FakeQuantWithMinMaxArgsGradient fakeQuantWithMinMaxArgsGradient(Operand<Float> gradients, Operand<Float> inputs, FakeQuantWithMinMaxArgsGradient.Options ... options) {
        return FakeQuantWithMinMaxArgsGradient.create(this.scope, gradients, inputs, options);
    }

    public FakeQuantWithMinMaxVarsPerChannel fakeQuantWithMinMaxVarsPerChannel(Operand<Float> inputs, Operand<Float> min, Operand<Float> max, FakeQuantWithMinMaxVarsPerChannel.Options ... options) {
        return FakeQuantWithMinMaxVarsPerChannel.create(this.scope, inputs, min, max, options);
    }

    public <T> Quantize<T> quantize(Operand<Float> input, Operand<Float> minRange, Operand<Float> maxRange, Class<T> T, Quantize.Options ... options) {
        return Quantize.create(this.scope, input, minRange, maxRange, T, options);
    }

    public <U, T> Requantize<U> requantize(Operand<T> input, Operand<Float> inputMin, Operand<Float> inputMax, Operand<Float> requestedOutputMin, Operand<Float> requestedOutputMax, Class<U> outType) {
        return Requantize.create(this.scope, input, inputMin, inputMax, requestedOutputMin, requestedOutputMax, outType);
    }

    public FakeQuantWithMinMaxArgs fakeQuantWithMinMaxArgs(Operand<Float> inputs, FakeQuantWithMinMaxArgs.Options ... options) {
        return FakeQuantWithMinMaxArgs.create(this.scope, inputs, options);
    }

    public <T extends Number> QuantizeAndDequantize<T> quantizeAndDequantize(Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Operand<Integer> numBits, QuantizeAndDequantize.Options ... options) {
        return QuantizeAndDequantize.create(this.scope, input, inputMin, inputMax, numBits, options);
    }

    public FakeQuantWithMinMaxVars fakeQuantWithMinMaxVars(Operand<Float> inputs, Operand<Float> min, Operand<Float> max, FakeQuantWithMinMaxVars.Options ... options) {
        return FakeQuantWithMinMaxVars.create(this.scope, inputs, min, max, options);
    }

    public <T> RequantizationRange requantizationRange(Operand<T> input, Operand<Float> inputMin, Operand<Float> inputMax) {
        return RequantizationRange.create(this.scope, input, inputMin, inputMax);
    }
}

