/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;
import org.tensorflow.AbstractOperation;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Shape;
import org.tensorflow.Tensor;

public final class Output<T>
implements Operand<T> {
    private final AbstractOperation operation;
    private final int index;

    public Operation op() {
        return this.operation;
    }

    public int index() {
        return this.index;
    }

    public Shape shape() {
        return new Shape(this.operation.shape(this.index));
    }

    public DataType dataType() {
        return this.operation.dtype(this.index);
    }

    public Tensor<T> tensor() {
        return this.operation.tensor(this.index);
    }

    @Override
    public Output<T> asOutput() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.operation, this.index);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Output) {
            Output that = (Output)o;
            return this.index == that.index && this.operation.equals(that.operation);
        }
        return false;
    }

    public String toString() {
        return String.format("<%s '%s:%d' shape=%s dtype=%s>", new Object[]{this.operation.type(), this.operation.name(), this.index, this.shape().toString(), this.dataType()});
    }

    Output(AbstractOperation op, int idx) {
        this.operation = op;
        this.index = idx;
    }

    long getUnsafeNativeHandle() {
        return this.operation.getUnsafeNativeHandle(this.index);
    }
}

