/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.ArrayList;
import java.util.List;
import org.kie.api.KieServices;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieLoggers;
import org.kie.api.logger.KieRuntimeLogger;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.LoggerType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.LoggerModel;
import org.switchyard.component.common.knowledge.config.model.LoggersModel;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.util.Disposals;

public final class Loggers {
    public static KnowledgeDisposal registerLoggersForDisposal(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager) {
        List<KieRuntimeLogger> loggers = Loggers.registerLoggers(model, loader, runtimeEventManager);
        return Disposals.newDisposal(loggers);
    }

    public static List<KieRuntimeLogger> registerLoggers(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager) {
        ArrayList<KieRuntimeLogger> loggers = new ArrayList<KieRuntimeLogger>();
        Loggers.registerLoggers(model, loader, runtimeEventManager, loggers);
        return loggers;
    }

    public static void registerLoggers(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager, List<KieRuntimeLogger> loggers) {
        LoggersModel loggersModel = model.getLoggers();
        if (loggersModel != null) {
            KieLoggers kieLoggers = KieServices.Factory.get().getLoggers();
            for (LoggerModel loggerModel : loggersModel.getLoggers()) {
                KieRuntimeLogger logger;
                String log;
                LoggerType loggerType = loggerModel.getType();
                if (loggerType == null) {
                    loggerType = LoggerType.THREADED_FILE;
                }
                if ((log = Strings.trimToNull((String)loggerModel.getLog())) == null) {
                    log = "event";
                }
                switch (loggerType) {
                    case CONSOLE: {
                        logger = kieLoggers.newConsoleLogger(runtimeEventManager);
                        break;
                    }
                    case FILE: {
                        logger = kieLoggers.newFileLogger(runtimeEventManager, log);
                        break;
                    }
                    case THREADED_FILE: {
                        Integer interval = loggerModel.getInterval();
                        if (interval == null) {
                            interval = 1000;
                        }
                        logger = kieLoggers.newThreadedFileLogger(runtimeEventManager, log, interval.intValue());
                        break;
                    }
                    default: {
                        logger = null;
                    }
                }
                if (logger == null) continue;
                loggers.add(logger);
            }
        }
    }

    private Loggers() {
    }
}

