/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.config.model.ChannelModel;
import org.switchyard.component.common.knowledge.config.model.ChannelsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceChannel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;

public final class Channels {
    public static void registerChannels(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntime runtime, ServiceDomain domain) {
        ChannelsModel channelsModel = model.getChannels();
        if (channelsModel != null) {
            String tns = model.getComponent().getTargetNamespace();
            for (ChannelModel channelModel : channelsModel.getChannels()) {
                Class<Object> channelClass = channelModel.getClazz(loader);
                if (channelClass == null) {
                    channelClass = SwitchYardServiceChannel.class;
                }
                Channel channel = (Channel)Construction.construct(channelClass);
                String name = channelModel.getName();
                if (channel instanceof SwitchYardServiceChannel) {
                    SwitchYardServiceChannel sysc = (SwitchYardServiceChannel)channel;
                    if (name != null) {
                        sysc.setName(name);
                    } else {
                        name = sysc.getName();
                    }
                    sysc.setInvoker(new SwitchYardServiceInvoker(domain, tns));
                    sysc.setComponentName(model.getComponent().getQName());
                    sysc.setServiceName(XMLHelper.createQName((String)channelModel.getReference()));
                    sysc.setOperationName(channelModel.getOperation());
                }
                if (name == null) {
                    throw new SwitchYardException("Could not use null name to register channel: " + channel.getClass().getName());
                }
                runtime.registerChannel(name, channel);
            }
        }
    }

    private Channels() {
    }
}

