/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.expression;

import java.io.Serializable;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.integration.impl.SimpleValueResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionType;

public class MVELExpression
implements Expression {
    private final String _expression;
    private final VariableResolverFactory _resolverFactory;
    private Serializable _compiled;

    public MVELExpression(String expression, PropertyResolver propertyResolver) {
        this._expression = expression;
        this._resolverFactory = new ResolverFactory(propertyResolver);
        this.compile();
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.MVEL;
    }

    private void compile() {
        ParserContext pc = new ParserContext();
        pc.addPackageImport("org.switchyard");
        this._compiled = MVEL.compileExpression((String)this._expression, (ParserContext)pc);
    }

    @Override
    public boolean isCompiled() {
        return this._compiled != null;
    }

    @Override
    public Object run() {
        return this.isCompiled() ? MVEL.executeExpression((Object)this._compiled, (VariableResolverFactory)this._resolverFactory) : MVEL.eval((String)this._expression, (VariableResolverFactory)this._resolverFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(Object context) {
        ResolverFactory.setContext(context);
        try {
            Object object = this.isCompiled() ? MVEL.executeExpression((Object)this._compiled, (Object)context, (VariableResolverFactory)this._resolverFactory) : MVEL.eval((String)this._expression, (Object)context, (VariableResolverFactory)this._resolverFactory);
            return object;
        }
        finally {
            ResolverFactory.setContext(null);
        }
    }

    private static final class ResolverFactory
    extends ImmutableDefaultFactory {
        private static final ThreadLocal<Map<String, Object>> CONTEXT = new ThreadLocal();
        private final PropertyResolver _propertyResolver;

        private static void setContext(Object context) {
            CONTEXT.set(context instanceof Map ? (Map)context : null);
        }

        private static boolean containsContext(String name) {
            Map<String, Object> context = CONTEXT.get();
            return context != null && context.containsKey(name);
        }

        private ResolverFactory(PropertyResolver propertyResolver) {
            this._propertyResolver = propertyResolver;
        }

        public boolean isResolveable(String name) {
            return name != null && (!ResolverFactory.containsContext(name) || this._propertyResolver.resolveProperty(name) != null);
        }

        public VariableResolver getVariableResolver(String name) {
            Object value = this.isResolveable(name) ? this._propertyResolver.resolveProperty(name) : null;
            return new SimpleValueResolver(value);
        }
    }
}

