/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.server;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.test.server.ResponseMatcher;
import org.springframework.ws.test.server.ResponseXPathExpectations;
import org.springframework.ws.test.server.SoapFaultResponseMatcher;
import org.springframework.ws.test.server.WebServiceMessageMatcherAdapter;
import org.springframework.ws.test.server.XPathExpectationsHelperAdapter;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.SchemaValidatingMatcher;
import org.springframework.ws.test.support.matcher.SoapHeaderMatcher;
import org.springframework.ws.test.support.matcher.xmlunit.PayloadDiffMatcher;
import org.springframework.ws.test.support.matcher.xmlunit.SoapEnvelopeDiffMatcher;
import org.springframework.xml.transform.ResourceSource;

public abstract class ResponseMatchers {
    private ResponseMatchers() {
    }

    public static ResponseMatcher payload(Source payload) {
        return new WebServiceMessageMatcherAdapter(new PayloadDiffMatcher(payload));
    }

    public static ResponseMatcher payload(Resource payload) throws IOException {
        return ResponseMatchers.payload((Source)new ResourceSource(payload));
    }

    public static ResponseMatcher validPayload(Resource schema, Resource ... furtherSchemas) throws IOException {
        return new WebServiceMessageMatcherAdapter(new SchemaValidatingMatcher(schema, furtherSchemas));
    }

    public static ResponseXPathExpectations xpath(String xpathExpression) {
        return new XPathExpectationsHelperAdapter(xpathExpression, null);
    }

    public static ResponseXPathExpectations xpath(String xpathExpression, Map<String, String> namespaceMapping) {
        return new XPathExpectationsHelperAdapter(xpathExpression, namespaceMapping);
    }

    public static ResponseMatcher soapEnvelope(Source soapEnvelope) {
        return new WebServiceMessageMatcherAdapter(new SoapEnvelopeDiffMatcher(soapEnvelope));
    }

    public static ResponseMatcher soapEnvelope(Resource soapEnvelope) throws IOException {
        return ResponseMatchers.soapEnvelope((Source)new ResourceSource(soapEnvelope));
    }

    public static ResponseMatcher soapHeader(QName soapHeaderName) {
        Assert.notNull((Object)soapHeaderName, (String)"'soapHeaderName' must not be null");
        return new WebServiceMessageMatcherAdapter(new SoapHeaderMatcher(soapHeaderName));
    }

    public static ResponseMatcher noFault() {
        return new ResponseMatcher(){

            @Override
            public void match(WebServiceMessage request, WebServiceMessage response) throws IOException, AssertionError {
                FaultAwareWebServiceMessage faultMessage;
                if (response instanceof FaultAwareWebServiceMessage && (faultMessage = (FaultAwareWebServiceMessage)response).hasFault()) {
                    AssertionErrors.fail("Response has a SOAP Fault: \"" + faultMessage.getFaultReason() + "\"");
                }
            }
        };
    }

    public static ResponseMatcher mustUnderstandFault() {
        return ResponseMatchers.mustUnderstandFault(null);
    }

    public static ResponseMatcher mustUnderstandFault(@Nullable String faultStringOrReason) {
        return new SoapFaultResponseMatcher(faultStringOrReason){

            @Override
            protected QName getExpectedFaultCode(SoapVersion version) {
                return version.getMustUnderstandFaultName();
            }
        };
    }

    public static ResponseMatcher clientOrSenderFault() {
        return ResponseMatchers.clientOrSenderFault(null);
    }

    public static ResponseMatcher clientOrSenderFault(@Nullable String faultStringOrReason) {
        return new SoapFaultResponseMatcher(faultStringOrReason){

            @Override
            protected QName getExpectedFaultCode(SoapVersion version) {
                return version.getClientOrSenderFaultName();
            }
        };
    }

    public static ResponseMatcher serverOrReceiverFault() {
        return ResponseMatchers.serverOrReceiverFault(null);
    }

    public static ResponseMatcher serverOrReceiverFault(@Nullable String faultStringOrReason) {
        return new SoapFaultResponseMatcher(faultStringOrReason){

            @Override
            protected QName getExpectedFaultCode(SoapVersion version) {
                return version.getServerOrReceiverFaultName();
            }
        };
    }

    public static ResponseMatcher versionMismatchFault() {
        return ResponseMatchers.versionMismatchFault(null);
    }

    public static ResponseMatcher versionMismatchFault(@Nullable String faultStringOrReason) {
        return new SoapFaultResponseMatcher(faultStringOrReason){

            @Override
            protected QName getExpectedFaultCode(SoapVersion version) {
                return version.getVersionMismatchFaultName();
            }
        };
    }
}

