/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.servlet.FlowUrlHandler;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.MvcExternalContext;

public class FlowHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FlowHandlerAdapter.class);
    private static final String REFERER_FLOW_EXECUTION_ATTRIBUTE = "refererExecution";
    private static final String SERVLET_RELATIVE_LOCATION_PREFIX = "servletRelative:";
    private static final String CONTEXT_RELATIVE_LOCATION_PREFIX = "contextRelative:";
    private static final String SERVER_RELATIVE_LOCATION_PREFIX = "serverRelative:";
    private FlowExecutor flowExecutor;
    private FlowUrlHandler flowUrlHandler;
    private AjaxHandler ajaxHandler;
    private boolean redirectHttp10Compatible = true;
    private HttpStatus statusCode;
    private String[] hosts;
    private boolean saveOutputToFlashScopeOnRedirect;

    public FlowHandlerAdapter() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    public void setFlowUrlHandler(FlowUrlHandler flowUrlHandler) {
        this.flowUrlHandler = flowUrlHandler;
    }

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    public boolean getRedirectHttp10Compatible() {
        return this.redirectHttp10Compatible;
    }

    public void setRedirectHttp10Compatible(boolean redirectHttp10Compatible) {
        this.redirectHttp10Compatible = redirectHttp10Compatible;
    }

    public void setStatusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public void setSaveOutputToFlashScopeOnRedirect(boolean saveOutputToFlashScopeOnRedirect) {
        this.saveOutputToFlashScopeOnRedirect = saveOutputToFlashScopeOnRedirect;
    }

    public boolean getSaveOutputToFlashScopeOnRedirect() {
        return this.saveOutputToFlashScopeOnRedirect;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowExecutor, (String)"The FlowExecutor to execute flows is required");
        if (this.flowUrlHandler == null) {
            this.flowUrlHandler = new DefaultFlowUrlHandler();
        }
        if (this.ajaxHandler == null) {
            this.ajaxHandler = new SpringJavascriptAjaxHandler();
        }
    }

    public boolean supports(Object handler) {
        return handler instanceof FlowHandler;
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        FlowHandler flowHandler = (FlowHandler)handler;
        this.checkAndPrepare(request, response, false);
        String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey(request);
        if (flowExecutionKey != null) {
            try {
                ServletExternalContext context = this.createServletExternalContext(request, response);
                FlowExecutionResult result = this.flowExecutor.resumeExecution(flowExecutionKey, context);
                this.handleFlowExecutionResult(result, context, request, response, flowHandler);
            }
            catch (FlowException e) {
                this.handleFlowException(e, request, response, flowHandler);
            }
        } else {
            try {
                String flowId = this.getFlowId(flowHandler, request);
                MutableAttributeMap<Object> input = this.getInputMap(flowHandler, request);
                ServletExternalContext context = this.createServletExternalContext(request, response);
                FlowExecutionResult result = this.flowExecutor.launchExecution(flowId, input, context);
                this.handleFlowExecutionResult(result, context, request, response, flowHandler);
            }
            catch (FlowException e) {
                this.handleFlowException(e, request, response, flowHandler);
            }
        }
        return null;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    protected ServletExternalContext createServletExternalContext(HttpServletRequest request, HttpServletResponse response) {
        MvcExternalContext context = new MvcExternalContext(this.getServletContext(), request, response, this.flowUrlHandler);
        context.setAjaxRequest(this.ajaxHandler.isAjaxRequest(request, response));
        return context;
    }

    protected String defaultGetFlowId(HttpServletRequest request) {
        return this.flowUrlHandler.getFlowId(request);
    }

    protected MutableAttributeMap<Object> defaultCreateFlowExecutionInputMap(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() == 0) {
            return null;
        }
        LocalAttributeMap<Object> inputMap = new LocalAttributeMap<Object>(parameterMap.size(), 1);
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            inputMap.put((String)entry.getKey(), values.length == 1 ? values[0] : values);
        }
        return inputMap;
    }

    protected void defaultHandleExecutionOutcome(String flowId, FlowExecutionOutcome outcome, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!context.isResponseComplete()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ended flow '" + flowId + "' did not commit a response; " + "attempting to start a new flow execution as a default outcome handler"));
            }
            String flowUrl = this.flowUrlHandler.createFlowDefinitionUrl(flowId, outcome.getOutput(), request);
            this.sendRedirect(flowUrl, request, response);
        }
    }

    protected void defaultHandleException(String flowId, FlowException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (e instanceof NoSuchFlowExecutionException && flowId != null) {
            if (!response.isCommitted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Restarting a new execution of previously ended flow '" + flowId + "'"));
                }
                String flowUrl = this.flowUrlHandler.createFlowDefinitionUrl(flowId, null, request);
                this.sendRedirect(flowUrl, request, response);
            }
        } else {
            throw e;
        }
    }

    protected void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            this.ajaxHandler.sendAjaxRedirect(url, request, response, false);
        } else {
            String encodedRedirectURL;
            String string = encodedRedirectURL = this.isRemoteHost(url) ? url : response.encodeRedirectURL(url);
            if (this.redirectHttp10Compatible) {
                if (this.statusCode != null) {
                    response.setStatus(this.statusCode.value());
                    response.setHeader("Location", encodedRedirectURL);
                } else {
                    response.sendRedirect(encodedRedirectURL);
                }
            } else {
                int code = this.statusCode != null ? this.statusCode.value() : 303;
                response.setStatus(code);
                response.setHeader("Location", response.encodeRedirectURL(url));
            }
        }
    }

    protected boolean isRemoteHost(String targetUrl) {
        if (ObjectUtils.isEmpty((Object[])this.getHosts())) {
            return false;
        }
        String targetHost = UriComponentsBuilder.fromUriString((String)targetUrl).build().getHost();
        if (StringUtils.isEmpty((Object)targetHost)) {
            return false;
        }
        for (String host : this.getHosts()) {
            if (!targetHost.equals(host)) continue;
            return false;
        }
        return true;
    }

    private void handleFlowExecutionResult(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response, FlowHandler handler) throws IOException {
        if (result.isPaused()) {
            if (context.getFlowExecutionRedirectRequested()) {
                this.sendFlowExecutionRedirect(result, context, request, response);
            } else if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response);
            }
        } else if (result.isEnded()) {
            if (context.getFlowDefinitionRedirectRequested()) {
                this.sendFlowDefinitionRedirect(result, context, request, response);
            } else if (context.getExternalRedirectRequested()) {
                this.sendExternalRedirect(context.getExternalRedirectUrl(), request, response, result);
            } else {
                String location = handler.handleExecutionOutcome(result.getOutcome(), request, response);
                if (location != null) {
                    this.sendExternalRedirect(location, request, response, result);
                } else {
                    this.defaultHandleExecutionOutcome(result.getFlowId(), result.getOutcome(), context, request, response);
                }
            }
        } else {
            throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
        }
    }

    private void sendFlowExecutionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = this.flowUrlHandler.createFlowExecutionUrl(result.getFlowId(), result.getPausedKey(), request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending flow execution redirect to '" + url + "'"));
        }
        if (context.isAjaxRequest()) {
            this.ajaxHandler.sendAjaxRedirect(url, request, response, context.getRedirectInPopup());
        } else {
            this.sendRedirect(url, request, response);
        }
    }

    private void sendFlowDefinitionRedirect(FlowExecutionResult result, ServletExternalContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String flowId = context.getFlowRedirectFlowId();
        MutableAttributeMap<Object> input = context.getFlowRedirectFlowInput();
        if (result.isPaused()) {
            input.put(REFERER_FLOW_EXECUTION_ATTRIBUTE, result.getPausedKey());
        }
        String url = this.flowUrlHandler.createFlowDefinitionUrl(flowId, input, request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending flow definition redirect to '" + url + "'"));
        }
        this.sendRedirect(url, request, response);
    }

    private void sendExternalRedirect(String location, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.sendExternalRedirect(location, request, response, null);
    }

    private void sendExternalRedirect(String location, HttpServletRequest request, HttpServletResponse response, FlowExecutionResult result) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending external redirect to '" + location + "'"));
        }
        if (location.startsWith(SERVLET_RELATIVE_LOCATION_PREFIX)) {
            this.sendServletRelativeRedirect(location.substring(SERVLET_RELATIVE_LOCATION_PREFIX.length()), request, response, result);
        } else if (location.startsWith(CONTEXT_RELATIVE_LOCATION_PREFIX)) {
            this.sendContextRelativeRedirect(location.substring(CONTEXT_RELATIVE_LOCATION_PREFIX.length()), request, response, result);
        } else if (location.startsWith(SERVER_RELATIVE_LOCATION_PREFIX)) {
            String url = location.substring(SERVER_RELATIVE_LOCATION_PREFIX.length());
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            this.sendRedirect(url, request, response);
        } else if (location.startsWith("http://") || location.startsWith("https://")) {
            this.sendRedirect(location, request, response);
        } else if (this.isRedirectServletRelative(request)) {
            this.sendServletRelativeRedirect(location, request, response, result);
        } else {
            this.sendContextRelativeRedirect(location, request, response, result);
        }
    }

    private boolean isRedirectServletRelative(HttpServletRequest request) {
        return request.getPathInfo() != null;
    }

    private void sendContextRelativeRedirect(String location, HttpServletRequest request, HttpServletResponse response, FlowExecutionResult result) throws IOException {
        StringBuilder url = new StringBuilder(request.getContextPath());
        if (!location.startsWith("/")) {
            url.append('/');
        }
        url.append(location);
        this.sendRedirect(url.toString(), request, response, result);
    }

    private void sendServletRelativeRedirect(String location, HttpServletRequest request, HttpServletResponse response, FlowExecutionResult result) throws IOException {
        StringBuilder url = new StringBuilder(request.getContextPath());
        url.append(request.getServletPath());
        if (!location.startsWith("/")) {
            url.append('/');
        }
        url.append(location);
        this.sendRedirect(url.toString(), request, response, result);
    }

    private void sendRedirect(String url, HttpServletRequest request, HttpServletResponse response, FlowExecutionResult result) throws IOException {
        if (this.saveOutputToFlashScopeOnRedirect) {
            this.saveFlashOutput(url.toString(), request, response, result);
        }
        this.sendRedirect(url, request, response);
    }

    private void saveFlashOutput(String location, HttpServletRequest request, HttpServletResponse response, FlowExecutionResult result) {
        if (result == null || result.getOutcome() == null || result.getOutcome().getOutput().isEmpty()) {
            return;
        }
        AttributeMap<Object> output = result.getOutcome().getOutput();
        FlashMapManager flashMapManager = RequestContextUtils.getFlashMapManager((HttpServletRequest)request);
        if (flashMapManager == null) {
            return;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)location).build();
        FlashMap flashMap = new FlashMap();
        flashMap.setTargetRequestPath(uriComponents.getPath());
        flashMap.addTargetRequestParams(uriComponents.getQueryParams());
        flashMap.putAll(output.asMap());
        flashMapManager.saveOutputFlashMap(flashMap, request, response);
    }

    private void handleFlowException(FlowException e, HttpServletRequest request, HttpServletResponse response, FlowHandler handler) throws IOException {
        String location = handler.handleException(e, request, response);
        if (location != null) {
            this.sendExternalRedirect(location, request, response);
        } else {
            this.defaultHandleException(this.getFlowId(handler, request), e, request, response);
        }
    }

    private String getFlowId(FlowHandler handler, HttpServletRequest request) {
        String flowId = handler.getFlowId();
        if (flowId != null) {
            return flowId;
        }
        return this.defaultGetFlowId(request);
    }

    private MutableAttributeMap<Object> getInputMap(FlowHandler handler, HttpServletRequest request) {
        MutableAttributeMap<Object> input = handler.createExecutionInputMap(request);
        if (input != null) {
            return input;
        }
        return this.defaultCreateFlowExecutionInputMap(request);
    }
}

