/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.portlet;

import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.webflow.context.portlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.portlet.FlowUrlHandler;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.portlet.FlowHandler;

public class FlowHandlerAdapter
extends PortletContentGenerator
implements HandlerAdapter,
InitializingBean {
    private static final String ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE = "actionRequestFlowException";
    private FlowExecutor flowExecutor;
    private FlowUrlHandler flowUrlHandler;

    public FlowHandlerAdapter() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowUrlHandler getFlowUrlHandler() {
        return this.flowUrlHandler;
    }

    public void setFlowUrlHandler(FlowUrlHandler urlHandler) {
        this.flowUrlHandler = urlHandler;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.flowExecutor, (String)"The FlowExecutor to execute flows is required");
        if (this.flowUrlHandler == null) {
            this.flowUrlHandler = new DefaultFlowUrlHandler();
        }
    }

    public boolean supports(Object handler) {
        return handler instanceof FlowHandler;
    }

    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        FlowHandler flowHandler = (FlowHandler)handler;
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        this.populateConveniencePortletProperties((PortletRequest)request);
        FlowException e = this.clearActionRequestFlowException(request, response, flowHandler);
        if (e != null) {
            return this.handleException(e, flowHandler, request, response);
        }
        String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey((PortletRequest)request);
        if (flowExecutionKey != null) {
            return this.resumeFlowRender(request, response, flowHandler, flowExecutionKey);
        }
        MutableAttributeMap<Object> input = flowHandler.createExecutionInputMap(request);
        if (input == null) {
            input = this.defaultCreateFlowExecutionInputMap((PortletRequest)request);
        }
        return this.startFlowRender(flowHandler, input, request, response);
    }

    public ModelAndView handleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        FlowHandler flowHandler = (FlowHandler)handler;
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        this.populateConveniencePortletProperties((PortletRequest)request);
        String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey((PortletRequest)request);
        if (flowExecutionKey != null) {
            return this.resumeFlowResource(request, response, flowHandler, flowExecutionKey);
        }
        MutableAttributeMap<Object> input = flowHandler.createResourceExecutionInputMap(request);
        if (input == null) {
            input = this.defaultCreateFlowExecutionInputMap((PortletRequest)request);
        }
        return this.startFlowResource(flowHandler, request, response);
    }

    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        block4: {
            FlowHandler flowHandler = (FlowHandler)handler;
            this.populateConveniencePortletProperties((PortletRequest)request);
            String flowExecutionKey = this.flowUrlHandler.getFlowExecutionKey((PortletRequest)request);
            PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
            try {
                FlowExecutionResult result = this.flowExecutor.resumeExecution(flowExecutionKey, context);
                if (result.isPaused()) {
                    this.flowUrlHandler.setFlowExecutionRenderParameter(result.getPausedKey(), response);
                    break block4;
                }
                if (result.isEnded()) {
                    this.handleFlowExecutionOutcome(result.getOutcome(), flowHandler, request, response);
                    break block4;
                }
                throw new IllegalStateException("Execution result should have been one of [paused] or [ended]");
            }
            catch (FlowException e) {
                request.getPortletSession().setAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE, (Object)e);
            }
        }
    }

    public void handleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
        response.setRenderParameters(request);
    }

    protected void populateConveniencePortletProperties(PortletRequest request) {
        request.setAttribute("portletMode", (Object)request.getPortletMode().toString());
        request.setAttribute("portletWindowState", (Object)request.getWindowState().toString());
    }

    protected PortletExternalContext createPortletExternalContext(PortletRequest request, PortletResponse response) {
        return new PortletExternalContext(this.getPortletContext(), request, response);
    }

    protected MutableAttributeMap<Object> defaultCreateFlowExecutionInputMap(PortletRequest request) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.size() == 0) {
            return null;
        }
        LocalAttributeMap<Object> inputMap = new LocalAttributeMap<Object>();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            inputMap.put((String)entry.getKey(), values.length == 1 ? values[0] : values);
        }
        return inputMap;
    }

    protected void defaultHandleExecutionOutcome(FlowExecutionOutcome outcome, FlowHandler flowHandler, ActionRequest request, ActionResponse response) throws PortletModeException {
    }

    protected ModelAndView defaultHandleException(FlowHandler flowHandler, FlowException e, RenderRequest request, RenderResponse response) {
        if (e instanceof NoSuchFlowExecutionException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting a new execution of previously ended flow '" + flowHandler.getFlowId() + "'"));
            }
            try {
                this.startFlowRender(flowHandler, null, request, response);
                return null;
            }
            catch (FlowException flowException) {
                return this.handleException(flowException, flowHandler, request, response);
            }
        }
        throw e;
    }

    protected ModelAndView defaultHandleResourceException(FlowHandler flowHandler, FlowException e, ResourceRequest request, ResourceResponse response) {
        if (e instanceof NoSuchFlowExecutionException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting a new execution of previously ended flow '" + flowHandler.getFlowId() + "'"));
            }
            return this.startFlowResource(flowHandler, request, response);
        }
        throw e;
    }

    private ModelAndView handleException(FlowException e, FlowHandler flowHandler, RenderRequest request, RenderResponse response) {
        String view = flowHandler.handleException(e, request, response);
        if (view != null) {
            return new ModelAndView(view);
        }
        return this.defaultHandleException(flowHandler, e, request, response);
    }

    private ModelAndView handleResourceException(FlowException e, FlowHandler flowHandler, ResourceRequest request, ResourceResponse response) {
        String view = flowHandler.handleResourceException(e, request, response);
        if (view != null) {
            return new ModelAndView(view);
        }
        return this.defaultHandleResourceException(flowHandler, e, request, response);
    }

    private void handleFlowExecutionOutcome(FlowExecutionOutcome outcome, FlowHandler flowHandler, ActionRequest request, ActionResponse response) throws PortletModeException {
        boolean handled = flowHandler.handleExecutionOutcome(outcome, request, response);
        if (!handled) {
            this.defaultHandleExecutionOutcome(outcome, flowHandler, request, response);
        }
    }

    private ModelAndView startFlowRender(FlowHandler flowHandler, MutableAttributeMap<Object> input, RenderRequest request, RenderResponse response) {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            FlowExecutionResult result = this.flowExecutor.launchExecution(flowHandler.getFlowId(), input, context);
            if (result.isPaused()) {
                this.flowUrlHandler.setFlowExecutionInSession(result.getPausedKey(), request);
            }
            return null;
        }
        catch (FlowException flowEx) {
            return this.handleException(flowEx, flowHandler, request, response);
        }
    }

    private ModelAndView startFlowResource(FlowHandler flowHandler, ResourceRequest request, ResourceResponse response) {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            FlowExecutionResult result = this.flowExecutor.launchExecution(flowHandler.getFlowId(), null, context);
            if (result.isPaused()) {
                this.flowUrlHandler.setFlowExecutionInSession(result.getPausedKey(), request);
            }
            return null;
        }
        catch (FlowException flowEx) {
            return this.handleResourceException(flowEx, flowHandler, request, response);
        }
    }

    private ModelAndView resumeFlowRender(RenderRequest request, RenderResponse response, FlowHandler flowHandler, String flowExecutionKey) {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            this.flowExecutor.resumeExecution(flowExecutionKey, context);
            return null;
        }
        catch (FlowException e) {
            return this.handleException(e, flowHandler, request, response);
        }
    }

    private ModelAndView resumeFlowResource(ResourceRequest request, ResourceResponse response, FlowHandler flowHandler, String flowExecutionKey) {
        PortletExternalContext context = this.createPortletExternalContext((PortletRequest)request, (PortletResponse)response);
        try {
            this.flowExecutor.resumeExecution(flowExecutionKey, context);
            return null;
        }
        catch (FlowException e) {
            return this.handleResourceException(e, flowHandler, request, response);
        }
    }

    private FlowException clearActionRequestFlowException(RenderRequest request, RenderResponse response, FlowHandler flowHandler) {
        FlowException e;
        PortletSession session = request.getPortletSession(false);
        if (session != null && (e = (FlowException)session.getAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE)) != null) {
            session.removeAttribute(ACTION_REQUEST_FLOW_EXCEPTION_ATTRIBUTE);
            return e;
        }
        return null;
    }
}

