/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.springframework.webflow.engine.model.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.model.builder.xml.WebFlowEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DefaultDocumentLoader
implements DocumentLoader {
    private static final Log logger = LogFactory.getLog(DefaultDocumentLoader.class);
    private static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private boolean validating = true;
    private EntityResolver entityResolver = new WebFlowEntityResolver();

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document loadDocument(Resource resource) throws IOException, ParserConfigurationException, SAXException {
        InputStream is = null;
        try {
            is = resource.getInputStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(this.isValidating());
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XSD_SCHEMA_LANGUAGE);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. " + "Are you running on Java 1.4 or below with Apache Crimson? " + "If so you must upgrade to Apache Xerces (or Java 5 or >) for full XSD support.");
            }
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler((ErrorHandler)new SimpleSaxErrorHandler(logger));
            docBuilder.setEntityResolver(this.getEntityResolver());
            Document document = docBuilder.parse(is);
            return document;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

