/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.FacesException;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.application.ResourceHandlerWrapper;
import jakarta.faces.application.ViewResource;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.net.URL;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowResourceHandler
extends ResourceHandlerWrapper {
    private final ResourceHandler wrapped;

    public FlowResourceHandler(ResourceHandler delegate) {
        this.wrapped = delegate;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public ViewResource createViewResource(FacesContext facesContext, String resourceName) {
        if (!JsfUtils.isFlowRequest()) {
            return this.wrapped.createViewResource(facesContext, resourceName);
        }
        try {
            RequestContext context = RequestContextHolder.getRequestContext();
            ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
            if (flowContext == null) {
                throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
            }
            ApplicationContext appContext = flowContext.getParent();
            Resource viewResource = appContext.getResource(resourceName);
            final URL url = viewResource.getURL();
            if (viewResource.exists()) {
                return new ViewResource(){

                    public URL getURL() {
                        return url;
                    }
                };
            }
            return this.wrapped.createViewResource(facesContext, resourceName);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }
}

