/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import org.springframework.faces.webflow.FlowLifecycle;
import org.springframework.faces.webflow.JsfUtils;

public class FacesContextHelper {
    private boolean release = false;

    public FacesContext getFacesContext(Object context, Object request, Object response) {
        FacesContext facesContext;
        if (FacesContext.getCurrentInstance() != null) {
            facesContext = FacesContext.getCurrentInstance();
        } else {
            facesContext = FacesContextHelper.newDefaultInstance(context, request, response, FlowLifecycle.newInstance());
            this.release = true;
        }
        return facesContext;
    }

    public void releaseIfNecessary() {
        if (this.release) {
            FacesContext.getCurrentInstance().release();
        }
    }

    public static FacesContext newDefaultInstance(Object context, Object request, Object response, Lifecycle lifecycle) {
        FacesContextFactory facesContextFactory = JsfUtils.findFactory(FacesContextFactory.class);
        return facesContextFactory.getFacesContext(context, request, response, lifecycle);
    }
}

