/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.springframework.remoting.caucho.HessianSkeletonInvoker;
import org.springframework.util.ClassUtils;
import org.springframework.util.CommonsLogWriter;

class Hessian2SkeletonInvoker
extends HessianSkeletonInvoker {
    private static final boolean debugOutputStreamAvailable = ClassUtils.isPresent("com.caucho.hessian.io.HessianDebugOutputStream", Hessian2SkeletonInvoker.class.getClassLoader());
    private final Log debugLogger;

    public Hessian2SkeletonInvoker(HessianSkeleton skeleton, SerializerFactory serializerFactory, Log debugLog) {
        super(skeleton, serializerFactory);
        this.debugLogger = debugLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        int code;
        InputStream isToUse = inputStream;
        OutputStream osToUse = outputStream;
        if (this.debugLogger != null && this.debugLogger.isDebugEnabled()) {
            PrintWriter debugWriter = new PrintWriter(new CommonsLogWriter(this.debugLogger));
            isToUse = new HessianDebugInputStream(inputStream, debugWriter);
            if (debugOutputStreamAvailable) {
                osToUse = DebugStreamFactory.createDebugOutputStream(outputStream, debugWriter);
            }
        }
        Hessian2Input in = new Hessian2Input(isToUse);
        if (this.serializerFactory != null) {
            in.setSerializerFactory(this.serializerFactory);
        }
        if ((code = in.read()) != 99) {
            throw new IOException("expected 'c' in hessian input at " + code);
        }
        Object out = null;
        int major = in.read();
        int minor = in.read();
        out = major >= 2 ? new Hessian2Output(osToUse) : new HessianOutput(osToUse);
        if (this.serializerFactory != null) {
            out.setSerializerFactory(this.serializerFactory);
        }
        try {
            this.skeleton.invoke((AbstractHessianInput)in, (AbstractHessianOutput)out);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                in.close();
                isToUse.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                out.close();
                osToUse.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            isToUse.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.close();
            osToUse.close();
        }
        catch (IOException ex) {}
    }

    private static class DebugStreamFactory {
        private DebugStreamFactory() {
        }

        public static OutputStream createDebugOutputStream(OutputStream os, PrintWriter debug) {
            return new HessianDebugOutputStream(os, debug);
        }
    }
}

