/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketExtension;

public class WebSocketHttpHeaders
extends HttpHeaders {
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WEBSOCKET_EXTENSIONS = "Sec-WebSocket-Extensions";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    private static final long serialVersionUID = -6644521016187828916L;

    public WebSocketHttpHeaders() {
    }

    public WebSocketHttpHeaders(HttpHeaders httpHeaders) {
        super(httpHeaders);
    }

    public void setSecWebSocketAccept(@Nullable String secWebSocketAccept) {
        this.set(SEC_WEBSOCKET_ACCEPT, secWebSocketAccept);
    }

    public @Nullable String getSecWebSocketAccept() {
        return this.getFirst(SEC_WEBSOCKET_ACCEPT);
    }

    public List<WebSocketExtension> getSecWebSocketExtensions() {
        List values = this.get(SEC_WEBSOCKET_EXTENSIONS);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>(values.size());
        for (String value : values) {
            result.addAll(WebSocketExtension.parseExtensions(value));
        }
        return result;
    }

    public void setSecWebSocketExtensions(List<WebSocketExtension> extensions) {
        ArrayList<String> result = new ArrayList<String>(extensions.size());
        for (WebSocketExtension extension : extensions) {
            result.add(extension.toString());
        }
        this.set(SEC_WEBSOCKET_EXTENSIONS, this.toCommaDelimitedString(result));
    }

    public void setSecWebSocketKey(@Nullable String secWebSocketKey) {
        this.set(SEC_WEBSOCKET_KEY, secWebSocketKey);
    }

    public @Nullable String getSecWebSocketKey() {
        return this.getFirst(SEC_WEBSOCKET_KEY);
    }

    public void setSecWebSocketProtocol(String secWebSocketProtocol) {
        this.set(SEC_WEBSOCKET_PROTOCOL, secWebSocketProtocol);
    }

    public void setSecWebSocketProtocol(List<String> secWebSocketProtocols) {
        this.set(SEC_WEBSOCKET_PROTOCOL, this.toCommaDelimitedString(secWebSocketProtocols));
    }

    public List<String> getSecWebSocketProtocol() {
        List values = this.get(SEC_WEBSOCKET_PROTOCOL);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return Collections.emptyList();
        }
        if (values.size() == 1) {
            return this.getValuesAsList(SEC_WEBSOCKET_PROTOCOL);
        }
        return values;
    }

    public void setSecWebSocketVersion(@Nullable String secWebSocketVersion) {
        this.set(SEC_WEBSOCKET_VERSION, secWebSocketVersion);
    }

    public @Nullable String getSecWebSocketVersion() {
        return this.getFirst(SEC_WEBSOCKET_VERSION);
    }
}

