/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.DefaultFragmentsRendering;
import org.springframework.web.servlet.view.FragmentsRendering;

final class DefaultFragmentsRenderingBuilder
implements FragmentsRendering.Builder {
    private @Nullable HttpStatusCode status;
    private @Nullable HttpHeaders headers;
    private final Collection<ModelAndView> fragments = new ArrayList<ModelAndView>();

    DefaultFragmentsRenderingBuilder() {
    }

    @Override
    public FragmentsRendering.Builder status(HttpStatusCode status) {
        this.status = status;
        return this;
    }

    @Override
    public FragmentsRendering.Builder header(String headerName, String ... headerValues) {
        this.initHeaders().put(headerName, Arrays.asList(headerValues));
        return this;
    }

    @Override
    public FragmentsRendering.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
        }
        return this.headers;
    }

    @Override
    public DefaultFragmentsRenderingBuilder fragment(String viewName, Map<String, Object> model) {
        return this.fragment(new ModelAndView(viewName, model));
    }

    @Override
    public DefaultFragmentsRenderingBuilder fragment(String viewName) {
        return this.fragment(new ModelAndView(viewName));
    }

    @Override
    public DefaultFragmentsRenderingBuilder fragment(ModelAndView fragment) {
        this.fragments.add(fragment);
        return this;
    }

    @Override
    public DefaultFragmentsRenderingBuilder fragments(Collection<ModelAndView> fragments) {
        this.fragments.addAll(fragments);
        return this;
    }

    @Override
    public FragmentsRendering build() {
        return new DefaultFragmentsRendering(this.status, this.headers != null ? this.headers : HttpHeaders.EMPTY, this.fragments);
    }
}

