/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public abstract class WebContentGenerator
extends WebApplicationObjectSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    protected static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private @Nullable Set<String> supportedMethods;
    private @Nullable String allowHeader;
    private boolean requireSession = false;
    private @Nullable CacheControl cacheControl;
    private int cacheSeconds = -1;
    private String @Nullable [] varyByRequestHeaders;

    public WebContentGenerator() {
        this(true);
    }

    public WebContentGenerator(boolean restrictDefaultSupportedMethods) {
        if (restrictDefaultSupportedMethods) {
            this.supportedMethods = CollectionUtils.newLinkedHashSet((int)3);
            this.supportedMethods.add(METHOD_GET);
            this.supportedMethods.add(METHOD_HEAD);
            this.supportedMethods.add(METHOD_POST);
        }
        this.initAllowHeader();
    }

    public WebContentGenerator(String ... supportedMethods) {
        this.setSupportedMethods(supportedMethods);
    }

    public final void setSupportedMethods(String ... methods) {
        this.supportedMethods = !ObjectUtils.isEmpty((Object[])methods) ? new LinkedHashSet<String>(Arrays.asList(methods)) : null;
        this.initAllowHeader();
    }

    public final String @Nullable [] getSupportedMethods() {
        return this.supportedMethods != null ? StringUtils.toStringArray(this.supportedMethods) : null;
    }

    private void initAllowHeader() {
        Collection<Object> allowedMethods;
        if (this.supportedMethods == null) {
            allowedMethods = new ArrayList(HttpMethod.values().length - 1);
            for (HttpMethod method : HttpMethod.values()) {
                if (method == HttpMethod.TRACE) continue;
                allowedMethods.add(method.name());
            }
        } else if (this.supportedMethods.contains(HttpMethod.OPTIONS.name())) {
            allowedMethods = this.supportedMethods;
        } else {
            allowedMethods = new ArrayList<String>(this.supportedMethods);
            allowedMethods.add(HttpMethod.OPTIONS.name());
        }
        this.allowHeader = StringUtils.collectionToCommaDelimitedString(allowedMethods);
    }

    protected @Nullable String getAllowHeader() {
        return this.allowHeader;
    }

    public final void setRequireSession(boolean requireSession) {
        this.requireSession = requireSession;
    }

    public final boolean isRequireSession() {
        return this.requireSession;
    }

    public final void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    public final @Nullable CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public final void setCacheSeconds(int seconds) {
        this.cacheSeconds = seconds;
    }

    public final int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public final void setVaryByRequestHeaders(String ... varyByRequestHeaders) {
        this.varyByRequestHeaders = varyByRequestHeaders;
    }

    public final String @Nullable [] getVaryByRequestHeaders() {
        return this.varyByRequestHeaders;
    }

    protected final void checkRequest(HttpServletRequest request) throws ServletException {
        String method = request.getMethod();
        if (this.supportedMethods != null && !this.supportedMethods.contains(method)) {
            throw new HttpRequestMethodNotSupportedException(method, this.supportedMethods);
        }
        if (this.requireSession && request.getSession(false) == null) {
            throw new HttpSessionRequiredException("Pre-existing session required but none found");
        }
    }

    protected final void prepareResponse(HttpServletResponse response) {
        if (this.cacheControl != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Applying default " + String.valueOf(this.getCacheControl())));
            }
            this.applyCacheControl(response, this.cacheControl);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Applying default cacheSeconds=" + this.cacheSeconds));
            }
            this.applyCacheSeconds(response, this.cacheSeconds);
        }
        if (this.varyByRequestHeaders != null) {
            for (String value : this.getVaryRequestHeadersToAdd(response, this.varyByRequestHeaders)) {
                response.addHeader("Vary", value);
            }
        }
    }

    protected final void applyCacheControl(HttpServletResponse response, CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            response.setHeader(HEADER_CACHE_CONTROL, ccValue);
        }
    }

    protected final void applyCacheSeconds(HttpServletResponse response, int cacheSeconds) {
        CacheControl cControl = cacheSeconds > 0 ? CacheControl.maxAge((long)cacheSeconds, (TimeUnit)TimeUnit.SECONDS) : (cacheSeconds == 0 ? CacheControl.noStore() : CacheControl.empty());
        this.applyCacheControl(response, cControl);
    }

    private Collection<String> getVaryRequestHeadersToAdd(HttpServletResponse response, String[] varyByRequestHeaders) {
        if (!response.containsHeader("Vary")) {
            return Arrays.asList(varyByRequestHeaders);
        }
        ArrayList<String> result = new ArrayList<String>(varyByRequestHeaders.length);
        Collections.addAll(result, varyByRequestHeaders);
        for (String header : response.getHeaders("Vary")) {
            for (String existing : StringUtils.tokenizeToStringArray((String)header, (String)",")) {
                if ("*".equals(existing)) {
                    return Collections.emptyList();
                }
                for (String value : varyByRequestHeaders) {
                    if (!value.equalsIgnoreCase(existing)) continue;
                    result.remove(value);
                }
            }
        }
        return result;
    }
}

