/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.DispatchExceptionHandler;

public class HandlerResult {
    private final Object handler;
    private final @Nullable Object returnValue;
    private final ResolvableType returnType;
    private final BindingContext bindingContext;
    private @Nullable DispatchExceptionHandler exceptionHandler;

    public HandlerResult(Object handler, @Nullable Object returnValue, MethodParameter returnType) {
        this(handler, returnValue, returnType, null);
    }

    public HandlerResult(Object handler, @Nullable Object returnValue, MethodParameter returnType, @Nullable BindingContext context) {
        Assert.notNull((Object)handler, (String)"'handler' is required");
        Assert.notNull((Object)returnType, (String)"'returnType' is required");
        this.handler = handler;
        this.returnValue = returnValue;
        this.returnType = ResolvableType.forMethodParameter((MethodParameter)returnType);
        this.bindingContext = context != null ? context : new BindingContext();
    }

    public Object getHandler() {
        return this.handler;
    }

    public @Nullable Object getReturnValue() {
        return this.returnValue;
    }

    public ResolvableType getReturnType() {
        return this.returnType;
    }

    public MethodParameter getReturnTypeSource() {
        return (MethodParameter)this.returnType.getSource();
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public Model getModel() {
        return this.bindingContext.getModel();
    }

    public HandlerResult setExceptionHandler(DispatchExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public @Nullable DispatchExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

