/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;
import org.springframework.web.service.registry.GroupsMetadata;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupAdapter;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;

public final class HttpServiceProxyRegistryFactoryBean
implements ApplicationContextAware,
BeanClassLoaderAware,
InitializingBean,
FactoryBean<HttpServiceProxyRegistry> {
    private static final Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> groupAdapters = GroupAdapterInitializer.initGroupAdapters();
    private final GroupsMetadata groupsMetadata;
    private @Nullable ApplicationContext applicationContext;
    private @Nullable ClassLoader beanClassLoader;
    private @Nullable HttpServiceProxyRegistry proxyRegistry;

    HttpServiceProxyRegistryFactoryBean(GroupsMetadata groupsMetadata) {
        this.groupsMetadata = groupsMetadata;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public Class<?> getObjectType() {
        return HttpServiceProxyRegistry.class;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext not initialized");
        Assert.notNull((Object)this.beanClassLoader, (String)"BeanClassLoader not initialized");
        Set groups = this.groupsMetadata.groups(this.beanClassLoader).stream().map(ProxyHttpServiceGroup::new).collect(Collectors.toSet());
        groupAdapters.forEach((clientType, groupAdapter) -> this.applicationContext.getBeanProvider(groupAdapter.getConfigurerType()).orderedStream().forEach(configurer -> configurer.configureGroups(new DefaultGroups(groups, (HttpServiceGroup.ClientType)((Object)clientType)))));
        Map<String, Map<Class<?>, Object>> proxies = groups.stream().collect(Collectors.toMap(ProxyHttpServiceGroup::name, ProxyHttpServiceGroup::createProxies));
        this.proxyRegistry = new DefaultHttpServiceProxyRegistry(proxies);
    }

    public HttpServiceProxyRegistry getObject() {
        Assert.state((this.proxyRegistry != null ? 1 : 0) != 0, (String)"HttpServiceProxyRegistry not initialized");
        return this.proxyRegistry;
    }

    private static final class DefaultHttpServiceProxyRegistry
    implements HttpServiceProxyRegistry {
        private final Map<String, Map<Class<?>, Object>> groupProxyMap;
        private final MultiValueMap<Class<?>, Object> directLookupMap;

        DefaultHttpServiceProxyRegistry(Map<String, Map<Class<?>, Object>> groupProxyMap) {
            this.groupProxyMap = groupProxyMap;
            this.directLookupMap = new LinkedMultiValueMap();
            groupProxyMap.values().forEach(map -> map.forEach((arg_0, arg_1) -> this.directLookupMap.add(arg_0, arg_1)));
        }

        @Override
        public <P> P getClient(Class<P> type) {
            List map = (List)this.directLookupMap.getOrDefault(type, Collections.emptyList());
            Assert.notEmpty((Collection)map, (String)("No client of type " + type.getName()));
            Assert.isTrue((map.size() <= 1 ? 1 : 0) != 0, (String)("No unique client of type " + type.getName()));
            return (P)map.get(0);
        }

        @Override
        public <P> P getClient(String groupName, Class<P> type) {
            Map<Class<?>, Object> map = this.getProxyMapForGroup(groupName);
            Object proxy = map.get(type);
            Assert.notNull((Object)proxy, (String)("No client of type " + String.valueOf(type) + " in group '" + groupName + "': " + String.valueOf(map.keySet())));
            return (P)proxy;
        }

        @Override
        public Set<String> getGroupNames() {
            return this.groupProxyMap.keySet();
        }

        @Override
        public Set<Class<?>> getClientTypesInGroup(String groupName) {
            return this.getProxyMapForGroup(groupName).keySet();
        }

        private Map<Class<?>, Object> getProxyMapForGroup(String groupName) {
            Map<Class<?>, Object> map = this.groupProxyMap.get(groupName);
            Assert.notNull(map, (String)("No group with name '" + groupName + "'"));
            return map;
        }
    }

    private static final class DefaultGroups<CB>
    implements HttpServiceGroupConfigurer.Groups<CB> {
        private final Set<ProxyHttpServiceGroup> groups;
        private final Predicate<HttpServiceGroup> defaultFilter;
        private Predicate<HttpServiceGroup> filter;

        DefaultGroups(Set<ProxyHttpServiceGroup> groups, HttpServiceGroup.ClientType clientType) {
            this.groups = groups;
            this.defaultFilter = group -> group.clientType().equals((Object)clientType);
            this.filter = this.defaultFilter;
        }

        @Override
        public HttpServiceGroupConfigurer.Groups<CB> filterByName(String ... groupNames) {
            return this.filter(group -> Arrays.stream(groupNames).anyMatch(name -> name.equals(group.name())));
        }

        @Override
        public HttpServiceGroupConfigurer.Groups<CB> filter(Predicate<HttpServiceGroup> predicate) {
            this.filter = this.filter.and(predicate);
            return this;
        }

        @Override
        public void forEachClient(HttpServiceGroupConfigurer.ClientCallback<CB> callback) {
            this.forEachGroup((group, clientBuilder, factoryBuilder) -> callback.withClient(group, clientBuilder));
        }

        @Override
        public void forEachProxyFactory(HttpServiceGroupConfigurer.ProxyFactoryCallback callback) {
            this.forEachGroup((group, clientBuilder, factoryBuilder) -> callback.withProxyFactory(group, factoryBuilder));
        }

        @Override
        public void forEachGroup(HttpServiceGroupConfigurer.GroupCallback<CB> callback) {
            this.groups.stream().filter(this.filter).forEach(group -> group.applyConfigurer(callback));
            this.filter = this.defaultFilter;
        }
    }

    private static class GroupAdapterInitializer {
        private static final String REST_CLIENT_HTTP_SERVICE_GROUP_ADAPTER = "org.springframework.web.client.support.RestClientHttpServiceGroupAdapter";
        private static final String WEB_CLIENT_HTTP_SERVICE_GROUP_ADAPTER = "org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupAdapter";

        private GroupAdapterInitializer() {
        }

        static Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> initGroupAdapters() {
            LinkedHashMap map = new LinkedHashMap(2);
            GroupAdapterInitializer.addGroupAdapter(map, HttpServiceGroup.ClientType.REST_CLIENT, REST_CLIENT_HTTP_SERVICE_GROUP_ADAPTER);
            GroupAdapterInitializer.addGroupAdapter(map, HttpServiceGroup.ClientType.WEB_CLIENT, WEB_CLIENT_HTTP_SERVICE_GROUP_ADAPTER);
            return map;
        }

        private static void addGroupAdapter(Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> groupAdapters, HttpServiceGroup.ClientType clientType, String className) {
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)HttpServiceGroupAdapter.class.getClassLoader());
                groupAdapters.put(clientType, (HttpServiceGroupAdapter)BeanUtils.instantiateClass((Class)clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static class HttpServiceProxyRegistryRuntimeHints
    implements RuntimeHintsRegistrar {
        HttpServiceProxyRegistryRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.web.client.support.RestClientHttpServiceGroupAdapter"), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}).registerTypeIfPresent(classLoader, "org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupAdapter", new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        }
    }

    private static final class ProxyHttpServiceGroup
    implements HttpServiceGroup {
        private final HttpServiceGroup declaredGroup;
        private final HttpServiceGroupAdapter<?> groupAdapter;
        private final Object clientBuilder;
        private final HttpServiceProxyFactory.Builder proxyFactoryBuilder = HttpServiceProxyFactory.builder();

        ProxyHttpServiceGroup(HttpServiceGroup group) {
            this.declaredGroup = group;
            this.groupAdapter = ProxyHttpServiceGroup.getGroupAdapter(group.clientType());
            this.clientBuilder = this.groupAdapter.createClientBuilder();
        }

        private static HttpServiceGroupAdapter<?> getGroupAdapter(HttpServiceGroup.ClientType clientType) {
            HttpServiceGroupAdapter<?> adapter = groupAdapters.get((Object)clientType);
            Assert.state((adapter != null ? 1 : 0) != 0, (String)("No HttpServiceGroupAdapter for type " + String.valueOf((Object)clientType)));
            return adapter;
        }

        @Override
        public String name() {
            return this.declaredGroup.name();
        }

        @Override
        public Set<Class<?>> httpServiceTypes() {
            return this.declaredGroup.httpServiceTypes();
        }

        @Override
        public HttpServiceGroup.ClientType clientType() {
            return this.declaredGroup.clientType();
        }

        public <CB> void applyConfigurer(HttpServiceGroupConfigurer.GroupCallback<CB> callback) {
            callback.withGroup(this, this.clientBuilder, this.proxyFactoryBuilder);
        }

        public Map<Class<?>, Object> createProxies() {
            LinkedHashMap map = new LinkedHashMap(this.httpServiceTypes().size());
            HttpServiceProxyFactory factory = this.proxyFactoryBuilder.exchangeAdapter(this.initExchangeAdapter()).build();
            this.httpServiceTypes().forEach(type -> map.put((Class<?>)type, factory.createClient(type)));
            return map;
        }

        private <CB> HttpExchangeAdapter initExchangeAdapter() {
            return this.groupAdapter.createExchangeAdapter(this.clientBuilder);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[name=" + this.name() + "]";
        }
    }
}

