/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpAsyncRequestControl;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpAsyncRequestControl;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ServletServerHttpRequest
implements ServerHttpRequest {
    protected static final Charset FORM_CHARSET = StandardCharsets.UTF_8;
    private final HttpServletRequest servletRequest;
    private @Nullable URI uri;
    private @Nullable HttpHeaders headers;
    private @Nullable Map<String, Object> attributes;
    private @Nullable ServerHttpAsyncRequestControl asyncRequestControl;

    public ServletServerHttpRequest(HttpServletRequest servletRequest) {
        Assert.notNull((Object)servletRequest, (String)"HttpServletRequest must not be null");
        this.servletRequest = servletRequest;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.servletRequest.getMethod());
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            this.uri = ServletServerHttpRequest.initURI(this.servletRequest);
        }
        return this.uri;
    }

    public static URI initURI(HttpServletRequest servletRequest) {
        String urlString = null;
        String query = null;
        boolean hasQuery = false;
        try {
            StringBuffer requestURL = servletRequest.getRequestURL();
            query = servletRequest.getQueryString();
            hasQuery = StringUtils.hasText((String)query);
            if (hasQuery) {
                requestURL.append('?').append(query);
            }
            urlString = requestURL.toString();
            return new URI(urlString);
        }
        catch (URISyntaxException ex) {
            if (hasQuery) {
                try {
                    query = UriComponentsBuilder.fromUriString("?" + query).build().toUri().getRawQuery();
                    return new URI(servletRequest.getRequestURL().toString() + "?" + query);
                }
                catch (URISyntaxException ex2) {
                    try {
                        return new URI(servletRequest.getRequestURL().toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
            throw new IllegalStateException("Could not resolve HttpServletRequest as URI: " + urlString, ex);
        }
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            int requestContentLength;
            this.headers = new HttpHeaders();
            Enumeration names = this.servletRequest.getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration headerValues = this.servletRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    this.headers.add(headerName, headerValue);
                }
            }
            try {
                String requestEncoding;
                String requestContentType;
                MediaType contentType = this.headers.getContentType();
                if (contentType == null && StringUtils.hasLength((String)(requestContentType = this.servletRequest.getContentType())) && (contentType = MediaType.parseMediaType(requestContentType)).isConcrete()) {
                    this.headers.setContentType(contentType);
                }
                if (contentType != null && contentType.getCharset() == null && StringUtils.hasLength((String)(requestEncoding = this.servletRequest.getCharacterEncoding()))) {
                    Charset charSet = Charset.forName(requestEncoding);
                    LinkedCaseInsensitiveMap params = new LinkedCaseInsensitiveMap();
                    params.putAll(contentType.getParameters());
                    params.put("charset", charSet.toString());
                    MediaType mediaType = new MediaType(contentType.getType(), contentType.getSubtype(), (Map<String, String>)params);
                    this.headers.setContentType(mediaType);
                }
            }
            catch (InvalidMediaTypeException contentType) {
                // empty catch block
            }
            if (this.headers.getContentLength() < 0L && (requestContentLength = this.servletRequest.getContentLength()) != -1) {
                this.headers.setContentLength(requestContentLength);
            }
        }
        return this.headers;
    }

    @Override
    public @Nullable Principal getPrincipal() {
        return this.servletRequest.getUserPrincipal();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.servletRequest.getLocalAddr(), this.servletRequest.getLocalPort());
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        String addressOrHost = this.servletRequest.getRemoteAddr();
        addressOrHost = addressOrHost != null ? addressOrHost : this.servletRequest.getRemoteHost();
        return new InetSocketAddress(addressOrHost, this.servletRequest.getRemotePort());
    }

    @Override
    public Map<String, Object> getAttributes() {
        AttributesMap attributes = this.attributes;
        if (attributes == null) {
            this.attributes = attributes = new AttributesMap();
        }
        return attributes;
    }

    @Override
    public InputStream getBody() throws IOException {
        if (ServletServerHttpRequest.isFormPost(this.servletRequest) && this.servletRequest.getQueryString() == null) {
            return this.getBodyFromServletRequestParameters(this.servletRequest);
        }
        return this.servletRequest.getInputStream();
    }

    @Override
    public ServerHttpAsyncRequestControl getAsyncRequestControl(ServerHttpResponse response) {
        if (this.asyncRequestControl == null) {
            if (!(response instanceof ServletServerHttpResponse)) {
                throw new IllegalArgumentException("Response must be a ServletServerHttpResponse: " + String.valueOf(response.getClass()));
            }
            ServletServerHttpResponse servletServerResponse = (ServletServerHttpResponse)response;
            this.asyncRequestControl = new ServletServerHttpAsyncRequestControl(this, servletServerResponse);
        }
        return this.asyncRequestControl;
    }

    private static boolean isFormPost(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && HttpMethod.POST.matches(request.getMethod());
    }

    private InputStream getBodyFromServletRequestParameters(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        Charset charset = this.getFormCharset();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, charset);
        Map form = request.getParameterMap();
        Iterator entryItr = form.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry entry = entryItr.next();
            List<String> values = Arrays.asList((String[])entry.getValue());
            Iterator<String> valueItr = values.iterator();
            while (valueItr.hasNext()) {
                String value = valueItr.next();
                writer.write(URLEncoder.encode((String)entry.getKey(), charset));
                if (value == null) continue;
                ((Writer)writer).write(61);
                writer.write(URLEncoder.encode(value, charset));
                if (!valueItr.hasNext()) continue;
                ((Writer)writer).write(38);
            }
            if (!entryItr.hasNext()) continue;
            writer.append('&');
        }
        ((Writer)writer).flush();
        byte[] bytes = bos.toByteArray();
        if (bytes.length > 0 && this.getHeaders().containsHeader("Content-Length")) {
            this.getHeaders().setContentLength(bytes.length);
        }
        return new ByteArrayInputStream(bytes);
    }

    private Charset getFormCharset() {
        try {
            MediaType contentType = this.getHeaders().getContentType();
            if (contentType != null && contentType.getCharset() != null) {
                return contentType.getCharset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FORM_CHARSET;
    }

    private final class AttributesMap
    extends AbstractMap<String, Object> {
        private transient @Nullable Set<String> keySet;
        private transient @Nullable Collection<Object> values;
        private transient @Nullable Set<Map.Entry<String, Object>> entrySet;

        private AttributesMap() {
        }

        @Override
        public int size() {
            int size = 0;
            Enumeration names = ServletServerHttpRequest.this.servletRequest.getAttributeNames();
            while (names.hasMoreElements()) {
                ++size;
                names.nextElement();
            }
            return size;
        }

        @Override
        public @Nullable Object get(Object key) {
            if (key instanceof String) {
                String name = (String)key;
                return ServletServerHttpRequest.this.servletRequest.getAttribute(name);
            }
            return null;
        }

        @Override
        public @Nullable Object put(String key, Object value) {
            Object old = this.get(key);
            ServletServerHttpRequest.this.servletRequest.setAttribute(key, value);
            return old;
        }

        @Override
        public @Nullable Object remove(Object key) {
            if (key instanceof String) {
                String name = (String)key;
                Object old = this.get(key);
                ServletServerHttpRequest.this.servletRequest.removeAttribute(name);
                return old;
            }
            return null;
        }

        @Override
        public void clear() {
            Enumeration names = ServletServerHttpRequest.this.servletRequest.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                ServletServerHttpRequest.this.servletRequest.removeAttribute(name);
            }
        }

        @Override
        public Set<String> keySet() {
            AbstractSet<String> keySet = this.keySet;
            if (keySet == null) {
                this.keySet = keySet = new AbstractSet<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return ServletServerHttpRequest.this.servletRequest.getAttributeNames().asIterator();
                    }

                    @Override
                    public int size() {
                        return AttributesMap.this.size();
                    }
                };
            }
            return keySet;
        }

        @Override
        public Collection<Object> values() {
            AbstractCollection<Object> values = this.values;
            if (values == null) {
                this.values = values = new AbstractCollection<Object>(){

                    @Override
                    public Iterator<Object> iterator() {
                        final Enumeration e = ServletServerHttpRequest.this.servletRequest.getAttributeNames();
                        return new Iterator<Object>(this){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public boolean hasNext() {
                                return e.hasMoreElements();
                            }

                            @Override
                            public Object next() {
                                String name = (String)e.nextElement();
                                return this.this$2.ServletServerHttpRequest.this.servletRequest.getAttribute(name);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return AttributesMap.this.size();
                    }
                };
            }
            return values;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            AbstractSet<Map.Entry<String, Object>> entrySet = this.entrySet;
            if (entrySet == null) {
                this.entrySet = entrySet = new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        final Enumeration e = ServletServerHttpRequest.this.servletRequest.getAttributeNames();
                        return new Iterator<Map.Entry<String, Object>>(this){
                            final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public boolean hasNext() {
                                return e.hasMoreElements();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                String name = (String)e.nextElement();
                                Object value = this.this$2.ServletServerHttpRequest.this.servletRequest.getAttribute(name);
                                return new AbstractMap.SimpleImmutableEntry<String, Object>(name, value);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return AttributesMap.this.size();
                    }
                };
            }
            return entrySet;
        }
    }
}

