/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.support.BaseDefaultCodecs;

class ServerDefaultCodecsImpl
extends BaseDefaultCodecs
implements ServerCodecConfigurer.ServerDefaultCodecs {
    private @Nullable Encoder<?> sseEncoder;

    ServerDefaultCodecsImpl() {
    }

    ServerDefaultCodecsImpl(ServerDefaultCodecsImpl other) {
        super(other);
        this.sseEncoder = other.sseEncoder;
    }

    @Override
    public void serverSentEventEncoder(Encoder<?> encoder) {
        this.sseEncoder = encoder;
        this.initObjectWriters();
    }

    @Override
    protected void extendObjectWriters(List<HttpMessageWriter<?>> objectWriters) {
        objectWriters.add(new ServerSentEventHttpMessageWriter(this.getSseEncoder()));
    }

    private @Nullable Encoder<?> getSseEncoder() {
        return this.sseEncoder != null ? this.sseEncoder : (jacksonPresent ? this.getJacksonJsonEncoder() : (jackson2Present ? this.getJackson2JsonEncoder() : (kotlinSerializationJsonPresent ? this.getKotlinSerializationJsonEncoder() : null)));
    }
}

