/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.CharBuffer;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xmlbeans.XMLStreamValidationException;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlSaxHandler;
import org.apache.xmlbeans.XmlValidationError;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XmlBeansMarshaller
extends AbstractMarshaller {
    private XmlOptions xmlOptions;
    private boolean validating = false;

    public void setXmlOptions(XmlOptions xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    public XmlOptions getXmlOptions() {
        return this.xmlOptions;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return XmlObject.class.isAssignableFrom(clazz);
    }

    @Override
    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        Node xmlBeansNode = ((XmlObject)graph).newDomNode(this.getXmlOptions());
        NodeList xmlBeansChildNodes = xmlBeansNode.getChildNodes();
        for (int i = 0; i < xmlBeansChildNodes.getLength(); ++i) {
            Node xmlBeansChildNode = xmlBeansChildNodes.item(i);
            Node importedNode = document.importNode(xmlBeansChildNode, true);
            node.appendChild(importedNode);
        }
    }

    @Override
    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLEventWriter)eventWriter);
        LexicalHandler lexicalHandler = null;
        if (contentHandler instanceof LexicalHandler) {
            lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
        this.marshalSaxHandlers(graph, contentHandler, lexicalHandler);
    }

    @Override
    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        ContentHandler contentHandler = StaxUtils.createContentHandler((XMLStreamWriter)streamWriter);
        LexicalHandler lexicalHandler = null;
        if (contentHandler instanceof LexicalHandler) {
            lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
        this.marshalSaxHandlers(graph, contentHandler, lexicalHandler);
    }

    @Override
    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            ((XmlObject)graph).save(contentHandler, lexicalHandler, this.getXmlOptions());
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, true);
        }
    }

    @Override
    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(outputStream, this.getXmlOptions());
    }

    @Override
    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        ((XmlObject)graph).save(writer, this.getXmlOptions());
    }

    @Override
    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((Node)node, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        XMLReader reader = StaxUtils.createXMLReader((XMLEventReader)eventReader);
        try {
            return this.unmarshalSaxReader(reader, new InputSource());
        }
        catch (IOException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
    }

    @Override
    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        try {
            XmlObject object = XmlObject.Factory.parse((XMLStreamReader)streamReader, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        XmlSaxHandler saxHandler = XmlObject.Factory.newXmlSaxHandler((XmlOptions)this.getXmlOptions());
        xmlReader.setContentHandler(saxHandler.getContentHandler());
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", saxHandler.getLexicalHandler());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        try {
            xmlReader.parse(inputSource);
            XmlObject object = saxHandler.getObject();
            this.validate(object);
            return object;
        }
        catch (SAXException ex) {
            throw this.convertXmlBeansException(ex, false);
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            NonClosingInputStream nonClosingInputStream = new NonClosingInputStream(inputStream);
            XmlObject object = XmlObject.Factory.parse((InputStream)nonClosingInputStream, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    @Override
    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            NonClosingReader nonClosingReader = new NonClosingReader(reader);
            XmlObject object = XmlObject.Factory.parse((Reader)nonClosingReader, (XmlOptions)this.getXmlOptions());
            this.validate(object);
            return object;
        }
        catch (XmlException ex) {
            throw this.convertXmlBeansException((Exception)((Object)ex), false);
        }
    }

    protected void validate(XmlObject object) throws ValidationFailureException {
        if (this.isValidating() && object != null) {
            XmlOptions validateOptions = this.getXmlOptions();
            if (validateOptions == null) {
                validateOptions = new XmlOptions();
            }
            ArrayList errorsList = new ArrayList();
            validateOptions.setErrorListener(errorsList);
            if (!object.validate(validateOptions)) {
                StringBuilder sb = new StringBuilder("Failed to validate XmlObject: ");
                boolean first = true;
                for (XmlError error : errorsList) {
                    if (!(error instanceof XmlValidationError)) continue;
                    if (!first) {
                        sb.append("; ");
                    }
                    sb.append(error.toString());
                    first = false;
                }
                throw new ValidationFailureException("XMLBeans validation failure", new XmlException(sb.toString(), null, errorsList));
            }
        }
    }

    protected XmlMappingException convertXmlBeansException(Exception ex, boolean marshalling) {
        if (ex instanceof XMLStreamValidationException) {
            return new ValidationFailureException("XMLBeans validation exception", ex);
        }
        if (ex instanceof XmlException || ex instanceof SAXException) {
            if (marshalling) {
                return new MarshallingFailureException("XMLBeans marshalling exception", ex);
            }
            return new UnmarshallingFailureException("XMLBeans unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown XMLBeans exception", ex);
    }

    private static class NonClosingReader
    extends Reader {
        private final WeakReference<Reader> reader;

        public NonClosingReader(Reader reader) {
            this.reader = new WeakReference<Reader>(reader);
        }

        private Reader getReader() {
            return (Reader)this.reader.get();
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(target) : -1;
        }

        @Override
        public int read() throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read() : -1;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(cbuf) : -1;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.read(cbuf, off, len) : -1;
        }

        @Override
        public long skip(long n) throws IOException {
            Reader rdr = this.getReader();
            return rdr != null ? rdr.skip(n) : 0L;
        }

        @Override
        public boolean ready() throws IOException {
            Reader rdr = this.getReader();
            return rdr != null && rdr.ready();
        }

        @Override
        public boolean markSupported() {
            Reader rdr = this.getReader();
            return rdr != null && rdr.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                rdr.mark(readAheadLimit);
            }
        }

        @Override
        public void reset() throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                rdr.reset();
            }
        }

        @Override
        public void close() throws IOException {
            Reader rdr = this.getReader();
            if (rdr != null) {
                this.reader.clear();
            }
        }
    }

    private static class NonClosingInputStream
    extends InputStream {
        private final WeakReference<InputStream> in;

        public NonClosingInputStream(InputStream in) {
            this.in = new WeakReference<InputStream>(in);
        }

        private InputStream getInputStream() {
            return (InputStream)this.in.get();
        }

        @Override
        public int read() throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read() : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read(b) : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.read(b, off, len) : -1;
        }

        @Override
        public long skip(long n) throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.skip(n) : 0L;
        }

        @Override
        public boolean markSupported() {
            InputStream in = this.getInputStream();
            return in != null && in.markSupported();
        }

        @Override
        public void mark(int readlimit) {
            InputStream in = this.getInputStream();
            if (in != null) {
                in.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            InputStream in = this.getInputStream();
            if (in != null) {
                in.reset();
            }
        }

        @Override
        public int available() throws IOException {
            InputStream in = this.getInputStream();
            return in != null ? in.available() : 0;
        }

        @Override
        public void close() throws IOException {
            InputStream in = this.getInputStream();
            if (in != null) {
                this.in.clear();
            }
        }
    }
}

