/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Convert;
import jakarta.persistence.Converter;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.IdClass;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class PersistenceManagedTypesBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private static final boolean JPA_PRESENT = ClassUtils.isPresent((String)"jakarta.persistence.Entity", (ClassLoader)PersistenceManagedTypesBeanRegistrationAotProcessor.class.getClassLoader());

    PersistenceManagedTypesBeanRegistrationAotProcessor() {
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (JPA_PRESENT && PersistenceManagedTypes.class.isAssignableFrom(registeredBean.getBeanClass())) {
            return BeanRegistrationAotContribution.withCustomCodeFragments(codeFragments -> new JpaManagedTypesBeanRegistrationCodeFragments((BeanRegistrationCodeFragments)codeFragments, registeredBean));
        }
        return null;
    }

    private static final class JpaManagedTypesBeanRegistrationCodeFragments
    extends BeanRegistrationCodeFragmentsDecorator {
        private static final List<Class<? extends Annotation>> CALLBACK_TYPES = List.of(PreUpdate.class, PostUpdate.class, PrePersist.class, PostPersist.class, PreRemove.class, PostRemove.class, PostLoad.class);
        private static final ParameterizedTypeName LIST_OF_STRINGS_TYPE = ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
        private final RegisteredBean registeredBean;
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        private JpaManagedTypesBeanRegistrationCodeFragments(BeanRegistrationCodeFragments codeFragments, RegisteredBean registeredBean) {
            super(codeFragments);
            this.registeredBean = registeredBean;
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
            PersistenceManagedTypes persistenceManagedTypes = (PersistenceManagedTypes)this.registeredBean.getBeanFactory().getBean(this.registeredBean.getBeanName(), PersistenceManagedTypes.class);
            this.contributeHints(generationContext.getRuntimeHints(), this.registeredBean.getBeanFactory().getBeanClassLoader(), persistenceManagedTypes.getManagedClassNames());
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("getInstance", method -> {
                Class<PersistenceManagedTypes> beanType = PersistenceManagedTypes.class;
                method.addJavadoc("Get the bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()});
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.returns(beanType);
                method.addStatement("$T managedClassNames = $T.of($L)", new Object[]{LIST_OF_STRINGS_TYPE, List.class, this.toCodeBlock(persistenceManagedTypes.getManagedClassNames())});
                method.addStatement("$T managedPackages = $T.of($L)", new Object[]{LIST_OF_STRINGS_TYPE, List.class, this.toCodeBlock(persistenceManagedTypes.getManagedPackages())});
                method.addStatement("return $T.of($L, $L)", new Object[]{beanType, "managedClassNames", "managedPackages"});
            });
            return generatedMethod.toMethodReference().toCodeBlock();
        }

        private CodeBlock toCodeBlock(List<String> values) {
            return CodeBlock.join(values.stream().map(value -> CodeBlock.of((String)"$S", (Object[])new Object[]{value})).toList(), (String)", ");
        }

        private void contributeHints(RuntimeHints hints, @Nullable ClassLoader classLoader, List<String> managedClassNames) {
            for (String managedClassName : managedClassNames) {
                try {
                    Class managedClass = ClassUtils.forName((String)managedClassName, null);
                    this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{managedClass});
                    this.contributeEntityListenersHints(hints, managedClass);
                    this.contributeIdClassHints(hints, managedClass);
                    this.contributeConverterHints(hints, managedClass);
                    this.contributeCallbackHints(hints, managedClass);
                    this.contributeHibernateHints(hints, classLoader, managedClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalArgumentException("Failed to instantiate the managed class: " + managedClassName, ex);
                }
            }
        }

        private void contributeEntityListenersHints(RuntimeHints hints, Class<?> managedClass) {
            EntityListeners entityListeners = (EntityListeners)AnnotationUtils.findAnnotation(managedClass, EntityListeners.class);
            if (entityListeners != null) {
                for (Class entityListener : entityListeners.value()) {
                    hints.reflection().registerType(entityListener, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
                }
            }
        }

        private void contributeIdClassHints(RuntimeHints hints, Class<?> managedClass) {
            IdClass idClass = (IdClass)AnnotationUtils.findAnnotation(managedClass, IdClass.class);
            if (idClass != null) {
                this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{idClass.value()});
            }
        }

        private void contributeConverterHints(RuntimeHints hints, Class<?> managedClass) {
            Convert convertClassAnnotation;
            Converter converter = (Converter)AnnotationUtils.findAnnotation(managedClass, Converter.class);
            ReflectionHints reflectionHints = hints.reflection();
            if (converter != null) {
                reflectionHints.registerType(managedClass, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
            if ((convertClassAnnotation = (Convert)AnnotationUtils.findAnnotation(managedClass, Convert.class)) != null) {
                reflectionHints.registerType(convertClassAnnotation.converter(), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
            ReflectionUtils.doWithFields(managedClass, field -> {
                Convert convertFieldAnnotation = (Convert)AnnotationUtils.findAnnotation((AnnotatedElement)field, Convert.class);
                if (convertFieldAnnotation != null && convertFieldAnnotation.converter() != AttributeConverter.class) {
                    reflectionHints.registerType(convertFieldAnnotation.converter(), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            });
        }

        private void contributeCallbackHints(RuntimeHints hints, Class<?> managedClass) {
            ReflectionHints reflection = hints.reflection();
            ReflectionUtils.doWithMethods(managedClass, method -> reflection.registerMethod(method, ExecutableMode.INVOKE), method -> CALLBACK_TYPES.stream().anyMatch(method::isAnnotationPresent));
        }

        private void contributeHibernateHints(RuntimeHints hints, @Nullable ClassLoader classLoader, Class<?> managedClass) {
            Class<? extends Annotation> attributeBinderTypeClass;
            Class<? extends Annotation> idGeneratorTypeClass;
            Class<? extends Annotation> valueGenerationTypeClass;
            ReflectionHints reflection = hints.reflection();
            Class<? extends Annotation> embeddableInstantiatorClass = JpaManagedTypesBeanRegistrationCodeFragments.loadClass("org.hibernate.annotations.EmbeddableInstantiator", classLoader);
            if (embeddableInstantiatorClass != null) {
                this.registerForReflection(reflection, AnnotationUtils.findAnnotation(managedClass, embeddableInstantiatorClass), "value");
                ReflectionUtils.doWithFields(managedClass, field -> {
                    this.registerForReflection(reflection, AnnotationUtils.findAnnotation((AnnotatedElement)field, (Class)embeddableInstantiatorClass), "value");
                    this.registerForReflection(reflection, AnnotationUtils.findAnnotation(field.getType(), (Class)embeddableInstantiatorClass), "value");
                });
                ReflectionUtils.doWithMethods(managedClass, method -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((Method)method, (Class)embeddableInstantiatorClass), "value"));
            }
            if ((valueGenerationTypeClass = JpaManagedTypesBeanRegistrationCodeFragments.loadClass("org.hibernate.annotations.ValueGenerationType", classLoader)) != null) {
                ReflectionUtils.doWithFields(managedClass, field -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((AnnotatedElement)field, (Class)valueGenerationTypeClass), "generatedBy"));
                ReflectionUtils.doWithMethods(managedClass, method -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((Method)method, (Class)valueGenerationTypeClass), "generatedBy"));
            }
            if ((idGeneratorTypeClass = JpaManagedTypesBeanRegistrationCodeFragments.loadClass("org.hibernate.annotations.IdGeneratorType", classLoader)) != null) {
                ReflectionUtils.doWithFields(managedClass, field -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((AnnotatedElement)field, (Class)idGeneratorTypeClass), "value"));
                ReflectionUtils.doWithMethods(managedClass, method -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((Method)method, (Class)idGeneratorTypeClass), "value"));
            }
            if ((attributeBinderTypeClass = JpaManagedTypesBeanRegistrationCodeFragments.loadClass("org.hibernate.annotations.AttributeBinderType", classLoader)) != null) {
                ReflectionUtils.doWithFields(managedClass, field -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((AnnotatedElement)field, (Class)attributeBinderTypeClass), "binder"));
                ReflectionUtils.doWithMethods(managedClass, method -> this.registerForReflection(reflection, AnnotationUtils.findAnnotation((Method)method, (Class)attributeBinderTypeClass), "binder"));
            }
        }

        private static @Nullable Class<? extends Annotation> loadClass(String className, @Nullable ClassLoader classLoader) {
            try {
                return ClassUtils.forName((String)className, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }

        private void registerForReflection(ReflectionHints reflection, @Nullable Annotation annotation, String attribute) {
            if (annotation == null) {
                return;
            }
            Class type = (Class)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get(attribute);
            reflection.registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
    }
}

