/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public abstract class CachedExpressionEvaluator {
    private final SpelExpressionParser parser;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    protected CachedExpressionEvaluator() {
        this(new SpelExpressionParser());
    }

    protected CachedExpressionEvaluator(SpelExpressionParser parser) {
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null");
        this.parser = parser;
    }

    protected SpelExpressionParser getParser() {
        return this.parser;
    }

    protected ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    protected Expression getExpression(Map<ExpressionKey, Expression> cache, AnnotatedElementKey elementKey, String expression) {
        ExpressionKey expressionKey = this.createKey(elementKey, expression);
        return cache.computeIfAbsent(expressionKey, key -> this.parseExpression(expression));
    }

    protected Expression parseExpression(String expression) {
        return this.getParser().parseExpression(expression);
    }

    private ExpressionKey createKey(AnnotatedElementKey elementKey, String expression) {
        return new ExpressionKey(elementKey, expression);
    }

    protected static class ExpressionKey
    implements Comparable<ExpressionKey> {
        private final AnnotatedElementKey element;
        private final String expression;

        protected ExpressionKey(AnnotatedElementKey element, String expression) {
            Assert.notNull((Object)element, (String)"AnnotatedElementKey must not be null");
            Assert.notNull((Object)expression, (String)"Expression must not be null");
            this.element = element;
            this.expression = expression;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof ExpressionKey)) return false;
            ExpressionKey that = (ExpressionKey)other;
            if (!this.element.equals(that.element)) return false;
            if (!this.expression.equals(that.expression)) return false;
            return true;
        }

        public int hashCode() {
            return this.element.hashCode() * 29 + this.expression.hashCode();
        }

        public String toString() {
            return String.valueOf(this.element) + " with expression \"" + this.expression + "\"";
        }

        @Override
        public int compareTo(ExpressionKey other) {
            int result = this.element.toString().compareTo(other.element.toString());
            if (result == 0) {
                result = this.expression.compareTo(other.expression);
            }
            return result;
        }
    }
}

