/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.parsing.ComponentDefinition;

public class BeanComponentDefinition
extends BeanDefinitionHolder
implements ComponentDefinition {
    private static final BeanDefinition[] EMPTY_BEAN_DEFINITION_ARRAY = new BeanDefinition[0];
    private static final BeanReference[] EMPTY_BEAN_REFERENCE_ARRAY = new BeanReference[0];
    private final BeanDefinition[] innerBeanDefinitions;
    private final BeanReference[] beanReferences;

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName) {
        this(new BeanDefinitionHolder(beanDefinition, beanName));
    }

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName, String @Nullable [] aliases) {
        this(new BeanDefinitionHolder(beanDefinition, beanName, aliases));
    }

    public BeanComponentDefinition(BeanDefinitionHolder beanDefinitionHolder) {
        super(beanDefinitionHolder);
        ArrayList<BeanDefinition> innerBeans = new ArrayList<BeanDefinition>();
        ArrayList<BeanReference> references = new ArrayList<BeanReference>();
        MutablePropertyValues propertyValues = beanDefinitionHolder.getBeanDefinition().getPropertyValues();
        for (PropertyValue propertyValue : propertyValues.getPropertyValues()) {
            Object value = propertyValue.getValue();
            if (value instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder beanDefHolder = (BeanDefinitionHolder)value;
                innerBeans.add(beanDefHolder.getBeanDefinition());
                continue;
            }
            if (value instanceof BeanDefinition) {
                BeanDefinition beanDef = (BeanDefinition)value;
                innerBeans.add(beanDef);
                continue;
            }
            if (!(value instanceof BeanReference)) continue;
            BeanReference beanRef = (BeanReference)value;
            references.add(beanRef);
        }
        this.innerBeanDefinitions = innerBeans.toArray(EMPTY_BEAN_DEFINITION_ARRAY);
        this.beanReferences = references.toArray(EMPTY_BEAN_REFERENCE_ARRAY);
    }

    @Override
    public String getName() {
        return this.getBeanName();
    }

    @Override
    public String getDescription() {
        return this.getShortDescription();
    }

    @Override
    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.getBeanDefinition()};
    }

    @Override
    public BeanDefinition[] getInnerBeanDefinitions() {
        return this.innerBeanDefinitions;
    }

    @Override
    public BeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof BeanComponentDefinition && super.equals(other);
    }
}

