/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Set;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.RedisSessionExpirationStore;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SortedSetRedisSessionExpirationStore
implements RedisSessionExpirationStore {
    private final RedisOperations<String, Object> redisOps;
    private String namespace;
    private int cleanupCount = 100;
    private Clock clock = Clock.systemUTC();
    private String expirationsKey;

    public SortedSetRedisSessionExpirationStore(RedisOperations<String, Object> redisOps, String namespace) {
        Assert.notNull(redisOps, (String)"redisOps cannot be null");
        this.redisOps = redisOps;
        this.setNamespace(namespace);
    }

    @Override
    public void save(RedisIndexedSessionRepository.RedisSession session) {
        long expirationInMillis = this.getExpirationTime(session).toEpochMilli();
        this.redisOps.opsForZSet().add((Object)this.expirationsKey, (Object)session.getId(), (double)expirationInMillis);
    }

    @Override
    public void remove(String sessionId) {
        this.redisOps.opsForZSet().remove((Object)this.expirationsKey, new Object[]{sessionId});
    }

    @Override
    public void cleanupExpiredSessions() {
        Set sessionIds = this.redisOps.opsForZSet().reverseRangeByScore((Object)this.expirationsKey, 0.0, (double)this.clock.millis(), 0L, (long)this.cleanupCount);
        if (CollectionUtils.isEmpty((Collection)sessionIds)) {
            return;
        }
        for (Object sessionId : sessionIds) {
            String sessionKey = this.getSessionKey((String)sessionId);
            this.touch(sessionKey);
        }
    }

    private Instant getExpirationTime(RedisIndexedSessionRepository.RedisSession session) {
        return session.getLastAccessedTime().plus(session.getMaxInactiveInterval());
    }

    private void touch(String sessionKey) {
        this.redisOps.hasKey((Object)sessionKey);
    }

    private String getSessionKey(String sessionId) {
        return this.namespace + ":sessions:" + sessionId;
    }

    public void setNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.namespace = namespace;
        this.expirationsKey = this.namespace + ":sessions:expirations";
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public void setCleanupCount(int cleanupCount) {
        Assert.state((cleanupCount > 0 ? 1 : 0) != 0, (String)"cleanupCount must be greater than 0");
        this.cleanupCount = cleanupCount;
    }
}

