/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jackson;

import jakarta.servlet.http.Cookie;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.node.MissingNode;
import tools.jackson.databind.node.NullNode;

class CookieDeserializer
extends ValueDeserializer<Cookie> {
    CookieDeserializer() {
    }

    public Cookie deserialize(JsonParser jp, DeserializationContext ctxt) throws JacksonException {
        JsonNode jsonNode = ctxt.readTree(jp);
        Cookie cookie = new Cookie(this.readJsonNode(jsonNode, "name").stringValue(), this.readJsonNode(jsonNode, "value").stringValue());
        JsonNode domainNode = this.readJsonNode(jsonNode, "domain");
        cookie.setDomain(domainNode.isMissingNode() ? null : domainNode.stringValue());
        cookie.setMaxAge(this.readJsonNode(jsonNode, "maxAge").asInt(-1));
        cookie.setSecure(this.readJsonNode(jsonNode, "secure").asBoolean());
        JsonNode pathNode = this.readJsonNode(jsonNode, "path");
        cookie.setPath(pathNode.isMissingNode() ? null : pathNode.stringValue());
        JsonNode attributes = this.readJsonNode(jsonNode, "attributes");
        cookie.setHttpOnly(this.readJsonNode(attributes, "HttpOnly") != null);
        return cookie;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return this.hasNonNullField(jsonNode, field) ? jsonNode.get(field) : MissingNode.getInstance();
    }

    private boolean hasNonNullField(JsonNode jsonNode, String field) {
        return jsonNode.has(field) && !(jsonNode.get(field) instanceof NullNode);
    }
}

