/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.method.annotation;

import java.lang.annotation.Annotation;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class CurrentSecurityContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ExpressionParser parser = new SpelExpressionParser();
    private final Class<CurrentSecurityContext> annotationType = CurrentSecurityContext.class;
    private SecurityAnnotationScanner<CurrentSecurityContext> scanner = SecurityAnnotationScanners.requireUnique(this.annotationType);
    private boolean useAnnotationTemplate = false;
    private @Nullable BeanResolver beanResolver;

    public boolean supportsParameter(MethodParameter parameter) {
        return SecurityContext.class.isAssignableFrom(parameter.getParameterType()) || this.findMethodAnnotation(parameter) != null;
    }

    public @Nullable Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) {
        SecurityContext securityContext = this.securityContextHolderStrategy.getContext();
        if (securityContext == null) {
            return null;
        }
        CurrentSecurityContext annotation = this.findMethodAnnotation(parameter);
        if (annotation != null) {
            return this.resolveSecurityContextFromAnnotation(parameter, annotation, securityContext);
        }
        return securityContext;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, (String)"beanResolver cannot be null");
        this.beanResolver = beanResolver;
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.useAnnotationTemplate = templateDefaults != null;
        this.scanner = SecurityAnnotationScanners.requireUnique(CurrentSecurityContext.class, (AnnotationTemplateExpressionDefaults)templateDefaults);
    }

    private @Nullable Object resolveSecurityContextFromAnnotation(MethodParameter parameter, CurrentSecurityContext annotation, SecurityContext securityContext) {
        Object securityContextResult = securityContext;
        String expressionToParse = annotation.expression();
        if (StringUtils.hasLength((String)expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)securityContext);
            context.setVariable("this", (Object)securityContext);
            if (this.beanResolver != null) {
                context.setBeanResolver(this.beanResolver);
            }
            Expression expression = this.parser.parseExpression(expressionToParse);
            securityContextResult = expression.getValue((EvaluationContext)context);
        }
        if (securityContextResult != null && !parameter.getParameterType().isAssignableFrom(securityContextResult.getClass())) {
            if (annotation.errorOnInvalidType()) {
                throw new ClassCastException(String.valueOf(securityContextResult) + " is not assignable to " + String.valueOf(parameter.getParameterType()));
            }
            return null;
        }
        return securityContextResult;
    }

    private @Nullable CurrentSecurityContext findMethodAnnotation(MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        if (this.useAnnotationTemplate) {
            return (CurrentSecurityContext)this.scanner.scan(parameter.getParameter());
        }
        CurrentSecurityContext annotation = (CurrentSecurityContext)parameter.getParameterAnnotation(this.annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = (CurrentSecurityContext)AnnotationUtils.findAnnotation(toSearch.annotationType(), this.annotationType);
            if (annotation == null) continue;
            return (CurrentSecurityContext)MergedAnnotations.from((Annotation[])new Annotation[]{toSearch}).get(this.annotationType).synthesize();
        }
        return null;
    }
}

