/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.Assert;

public final class HttpStatusAccessDeniedHandler
implements AccessDeniedHandler {
    private static final Log logger = LogFactory.getLog(HttpStatusAccessDeniedHandler.class);
    private final HttpStatus httpStatus;

    public HttpStatusAccessDeniedHandler(HttpStatus httpStatus) {
        Assert.notNull((Object)httpStatus, (String)"httpStatus cannot be null");
        this.httpStatus = httpStatus;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        logger.debug((Object)LogMessage.format((String)"Access denied with status code %d", (Object)this.httpStatus.value()));
        response.sendError(this.httpStatus.value(), "Access Denied");
    }
}

